/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUtils {
    private static final Logger log = LoggerFactory.getLogger(SQLUtils.class);

    public static Long countForSubquery(Connection connection, String subQuerySQL) throws SQLException {
        String sqlQuery = String.format("SELECT COUNT(*) FROM (%s) T", subQuerySQL);
        log.info("Split Chunk, countForSubquery: {}", (Object)sqlQuery);
        try (Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(sqlQuery);){
            if (resultSet.next()) {
                Long l = resultSet.getLong(1);
                return l;
            }
            throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
        }
    }

    public static Long countForTable(Connection connection, String tablePath) throws SQLException {
        String sqlQuery = String.format("SELECT COUNT(*) FROM %s", tablePath);
        log.info("Split Chunk, countForTable: {}", (Object)sqlQuery);
        try (Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(sqlQuery);){
            if (resultSet.next()) {
                Long l = resultSet.getLong(1);
                return l;
            }
            throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
        }
    }
}

