/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation;

import java.util.Collections;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.KeyException;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.operation.RegionErrorHandler;
import org.tikv.common.region.RegionErrorReceiver;
import org.tikv.common.region.RegionManager;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.txn.AbstractLockResolverClient;
import org.tikv.txn.Lock;
import org.tikv.txn.ResolveLockResult;

public class KVErrorHandler<RespT>
implements ErrorHandler<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(KVErrorHandler.class);
    private final Function<RespT, Kvrpcpb.KeyError> getKeyError;
    private final Function<ResolveLockResult, Object> resolveLockResultCallback;
    private final AbstractLockResolverClient lockResolverClient;
    private final long callerStartTS;
    private final boolean forWrite;
    private final RegionErrorHandler<RespT> regionHandler;

    public KVErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, AbstractLockResolverClient lockResolverClient, Function<RespT, Errorpb.Error> getRegionError, Function<RespT, Kvrpcpb.KeyError> getKeyError, Function<ResolveLockResult, Object> resolveLockResultCallback, long callerStartTS, boolean forWrite) {
        this.regionHandler = new RegionErrorHandler<RespT>(regionManager, recv, getRegionError);
        this.lockResolverClient = lockResolverClient;
        this.getKeyError = getKeyError;
        this.resolveLockResultCallback = resolveLockResultCallback;
        this.callerStartTS = callerStartTS;
        this.forWrite = forWrite;
    }

    private void resolveLock(BackOffer backOffer, Lock lock) {
        if (this.lockResolverClient != null) {
            logger.warn("resolving lock");
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, this.callerStartTS, Collections.singletonList(lock), this.forWrite);
            this.resolveLockResultCallback.apply(resolveLockResult);
            long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
            if (msBeforeExpired > 0L) {
                backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLockFast, msBeforeExpired, new KeyException(lock.toString()));
            }
        }
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            String msg = String.format("Request Failed with unknown reason for [%s]", this.regionHandler.getRegion());
            logger.warn(msg);
            return this.handleRequestError(backOffer, new GrpcException(msg));
        }
        Errorpb.Error error = this.regionHandler.getRegionError(resp);
        if (error != null) {
            return this.regionHandler.handleRegionError(backOffer, error);
        }
        Kvrpcpb.KeyError keyError = this.getKeyError.apply(resp);
        if (keyError != null) {
            try {
                Lock lock = AbstractLockResolverClient.extractLockFromKeyErr(keyError);
                this.resolveLock(backOffer, lock);
                return true;
            }
            catch (KeyException e) {
                logger.warn("Unable to handle KeyExceptions other than LockException", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        return this.regionHandler.handleRequestError(backOffer, e);
    }
}

