/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.service.failsafe;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.service.failsafe.CircuitBreaker;
import org.tikv.service.failsafe.CircuitBreakerMetrics;
import org.tikv.service.failsafe.CircuitBreakerMetricsImpl;
import org.tikv.service.failsafe.MetricsListener;
import org.tikv.service.failsafe.NoOpCircuitBreakerMetrics;
import org.tikv.shade.io.prometheus.client.Counter;

public class CircuitBreakerImpl
implements CircuitBreaker {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerImpl.class);
    private static final Counter CIRCUIT_BREAKER_ATTEMPT_COUNTER = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_circuit_breaker_attempt_counter")).help("client circuit breaker attempt counter.")).labelNames("type")).register();
    private final boolean enable;
    private final int windowInSeconds;
    private final int errorThresholdPercentage;
    private final int requestVolumeThreshold;
    private final int sleepWindowInSeconds;
    private final int attemptRequestCount;
    private final AtomicLong circuitOpened = new AtomicLong(-1L);
    private final AtomicReference<CircuitBreaker.Status> status = new AtomicReference<CircuitBreaker.Status>(CircuitBreaker.Status.CLOSED);
    private final AtomicLong attemptCount = new AtomicLong(0L);
    private final AtomicLong attemptSuccessCount = new AtomicLong(0L);
    private final CircuitBreakerMetrics metrics;

    public CircuitBreakerImpl(TiConfiguration conf) {
        this(conf.isCircuitBreakEnable(), conf.getCircuitBreakAvailabilityWindowInSeconds(), conf.getCircuitBreakAvailabilityErrorThresholdPercentage(), conf.getCircuitBreakAvailabilityRequestVolumnThreshold(), conf.getCircuitBreakSleepWindowInSeconds(), conf.getCircuitBreakAttemptRequestCount());
    }

    public CircuitBreakerImpl(boolean enable, int windowInSeconds, int errorThresholdPercentage, int requestVolumeThreshold, int sleepWindowInSeconds, int attemptRequestCount) {
        this.enable = enable;
        this.windowInSeconds = windowInSeconds;
        this.errorThresholdPercentage = errorThresholdPercentage;
        this.requestVolumeThreshold = requestVolumeThreshold;
        this.sleepWindowInSeconds = sleepWindowInSeconds;
        this.attemptRequestCount = attemptRequestCount;
        this.metrics = enable ? new CircuitBreakerMetricsImpl(windowInSeconds) : new NoOpCircuitBreakerMetrics();
        this.metrics.addListener(this.getMetricsListener());
    }

    private MetricsListener getMetricsListener() {
        return hc -> {
            logger.debug("onNext " + hc.toString());
            if (hc.getTotalRequests() >= (long)this.requestVolumeThreshold && hc.getErrorPercentage() >= this.errorThresholdPercentage) {
                this.close2Open();
            }
        };
    }

    @Override
    public CircuitBreakerMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean allowRequest() {
        if (!this.enable) {
            return true;
        }
        return !this.isOpen();
    }

    boolean isOpen() {
        return this.circuitOpened.get() >= 0L;
    }

    CircuitBreaker.Status getStatus() {
        return this.status.get();
    }

    @Override
    public void recordAttemptSuccess() {
        ((Counter.Child)CIRCUIT_BREAKER_ATTEMPT_COUNTER.labels("success")).inc();
        if (this.attemptSuccessCount.incrementAndGet() >= (long)this.attemptRequestCount) {
            this.halfOpen2Close();
        }
    }

    @Override
    public void recordAttemptFailure() {
        ((Counter.Child)CIRCUIT_BREAKER_ATTEMPT_COUNTER.labels("failure")).inc();
        this.halfOpen2Open();
    }

    @Override
    public boolean attemptExecution() {
        if (this.allowRequest()) {
            return true;
        }
        if (this.isAfterSleepWindow()) {
            this.open2HalfOpen();
            return this.attemptCount.incrementAndGet() <= (long)this.attemptRequestCount;
        }
        return false;
    }

    private boolean isAfterSleepWindow() {
        long sleepWindowTime;
        long circuitOpenTime = this.circuitOpened.get();
        long currentTime = System.currentTimeMillis();
        return currentTime >= circuitOpenTime + (sleepWindowTime = (long)this.sleepWindowInSeconds * 1000L);
    }

    private void close2Open() {
        if (this.status.compareAndSet(CircuitBreaker.Status.CLOSED, CircuitBreaker.Status.OPEN)) {
            this.circuitOpened.set(System.currentTimeMillis());
            logger.info("CLOSED => OPEN");
        }
    }

    private void halfOpen2Close() {
        if (this.status.compareAndSet(CircuitBreaker.Status.HALF_OPEN, CircuitBreaker.Status.CLOSED)) {
            this.circuitOpened.set(-1L);
            logger.info("HALF_OPEN => CLOSED");
        }
    }

    private void open2HalfOpen() {
        if (this.status.compareAndSet(CircuitBreaker.Status.OPEN, CircuitBreaker.Status.HALF_OPEN)) {
            this.attemptCount.set(0L);
            this.attemptSuccessCount.set(0L);
            logger.info("OPEN => HALF_OPEN");
        }
    }

    private void halfOpen2Open() {
        if (this.status.compareAndSet(CircuitBreaker.Status.HALF_OPEN, CircuitBreaker.Status.OPEN)) {
            this.circuitOpened.set(System.currentTimeMillis());
            logger.info("HALF_OPEN => OPEN");
        }
    }

    @Override
    public void close() throws IOException {
        this.metrics.close();
    }
}

