/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;

public class JdbcSourceConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private JdbcConnectionConfig jdbcConnectionConfig;
    public String query;
    private String partitionColumn;
    private Long partitionUpperBound;
    private Long partitionLowerBound;
    private int fetchSize;
    private Integer partitionNumber;

    public static JdbcSourceConfig of(ReadonlyConfig config) {
        Builder builder = JdbcSourceConfig.builder();
        builder.jdbcConnectionConfig(JdbcConnectionConfig.of(config));
        builder.query((String)config.get(JdbcOptions.QUERY));
        builder.fetchSize((Integer)config.get(JdbcOptions.FETCH_SIZE));
        config.getOptional(JdbcOptions.PARTITION_COLUMN).ifPresent(builder::partitionColumn);
        config.getOptional(JdbcOptions.PARTITION_UPPER_BOUND).ifPresent(builder::partitionUpperBound);
        config.getOptional(JdbcOptions.PARTITION_LOWER_BOUND).ifPresent(builder::partitionLowerBound);
        config.getOptional(JdbcOptions.PARTITION_NUM).ifPresent(builder::partitionNumber);
        return builder.build();
    }

    public JdbcConnectionConfig getJdbcConnectionConfig() {
        return this.jdbcConnectionConfig;
    }

    public Optional<String> getPartitionColumn() {
        return Optional.ofNullable(this.partitionColumn);
    }

    public Optional<Long> getPartitionUpperBound() {
        return Optional.ofNullable(this.partitionUpperBound);
    }

    public Optional<Long> getPartitionLowerBound() {
        return Optional.ofNullable(this.partitionLowerBound);
    }

    public Optional<Integer> getPartitionNumber() {
        return Optional.ofNullable(this.partitionNumber);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    JdbcSourceConfig(JdbcConnectionConfig jdbcConnectionConfig, String query, String partitionColumn, Long partitionUpperBound, Long partitionLowerBound, int fetchSize, Integer partitionNumber) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
        this.query = query;
        this.partitionColumn = partitionColumn;
        this.partitionUpperBound = partitionUpperBound;
        this.partitionLowerBound = partitionLowerBound;
        this.fetchSize = fetchSize;
        this.partitionNumber = partitionNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getQuery() {
        return this.query;
    }

    public void setJdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPartitionColumn(String partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public void setPartitionUpperBound(Long partitionUpperBound) {
        this.partitionUpperBound = partitionUpperBound;
    }

    public void setPartitionLowerBound(Long partitionLowerBound) {
        this.partitionLowerBound = partitionLowerBound;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPartitionNumber(Integer partitionNumber) {
        this.partitionNumber = partitionNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSourceConfig)) {
            return false;
        }
        JdbcSourceConfig other = (JdbcSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFetchSize() != other.getFetchSize()) {
            return false;
        }
        Optional<Long> this$partitionUpperBound = this.getPartitionUpperBound();
        Optional<Long> other$partitionUpperBound = other.getPartitionUpperBound();
        if (this$partitionUpperBound == null ? other$partitionUpperBound != null : !((Object)this$partitionUpperBound).equals(other$partitionUpperBound)) {
            return false;
        }
        Optional<Long> this$partitionLowerBound = this.getPartitionLowerBound();
        Optional<Long> other$partitionLowerBound = other.getPartitionLowerBound();
        if (this$partitionLowerBound == null ? other$partitionLowerBound != null : !((Object)this$partitionLowerBound).equals(other$partitionLowerBound)) {
            return false;
        }
        Optional<Integer> this$partitionNumber = this.getPartitionNumber();
        Optional<Integer> other$partitionNumber = other.getPartitionNumber();
        if (this$partitionNumber == null ? other$partitionNumber != null : !((Object)this$partitionNumber).equals(other$partitionNumber)) {
            return false;
        }
        JdbcConnectionConfig this$jdbcConnectionConfig = this.getJdbcConnectionConfig();
        JdbcConnectionConfig other$jdbcConnectionConfig = other.getJdbcConnectionConfig();
        if (this$jdbcConnectionConfig == null ? other$jdbcConnectionConfig != null : !this$jdbcConnectionConfig.equals(other$jdbcConnectionConfig)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Optional<String> this$partitionColumn = this.getPartitionColumn();
        Optional<String> other$partitionColumn = other.getPartitionColumn();
        return !(this$partitionColumn == null ? other$partitionColumn != null : !((Object)this$partitionColumn).equals(other$partitionColumn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFetchSize();
        Optional<Long> $partitionUpperBound = this.getPartitionUpperBound();
        result = result * 59 + ($partitionUpperBound == null ? 43 : ((Object)$partitionUpperBound).hashCode());
        Optional<Long> $partitionLowerBound = this.getPartitionLowerBound();
        result = result * 59 + ($partitionLowerBound == null ? 43 : ((Object)$partitionLowerBound).hashCode());
        Optional<Integer> $partitionNumber = this.getPartitionNumber();
        result = result * 59 + ($partitionNumber == null ? 43 : ((Object)$partitionNumber).hashCode());
        JdbcConnectionConfig $jdbcConnectionConfig = this.getJdbcConnectionConfig();
        result = result * 59 + ($jdbcConnectionConfig == null ? 43 : $jdbcConnectionConfig.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Optional<String> $partitionColumn = this.getPartitionColumn();
        result = result * 59 + ($partitionColumn == null ? 43 : ((Object)$partitionColumn).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSourceConfig(jdbcConnectionConfig=" + this.getJdbcConnectionConfig() + ", query=" + this.getQuery() + ", partitionColumn=" + this.getPartitionColumn() + ", partitionUpperBound=" + this.getPartitionUpperBound() + ", partitionLowerBound=" + this.getPartitionLowerBound() + ", fetchSize=" + this.getFetchSize() + ", partitionNumber=" + this.getPartitionNumber() + ")";
    }

    public static class Builder {
        private JdbcConnectionConfig jdbcConnectionConfig;
        private String query;
        private String partitionColumn;
        private Long partitionUpperBound;
        private Long partitionLowerBound;
        private int fetchSize;
        private Integer partitionNumber;

        Builder() {
        }

        public Builder jdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
            this.jdbcConnectionConfig = jdbcConnectionConfig;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder partitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        public Builder partitionUpperBound(Long partitionUpperBound) {
            this.partitionUpperBound = partitionUpperBound;
            return this;
        }

        public Builder partitionLowerBound(Long partitionLowerBound) {
            this.partitionLowerBound = partitionLowerBound;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public JdbcSourceConfig build() {
            return new JdbcSourceConfig(this.jdbcConnectionConfig, this.query, this.partitionColumn, this.partitionUpperBound, this.partitionLowerBound, this.fetchSize, this.partitionNumber);
        }

        public String toString() {
            return "JdbcSourceConfig.Builder(jdbcConnectionConfig=" + this.jdbcConnectionConfig + ", query=" + this.query + ", partitionColumn=" + this.partitionColumn + ", partitionUpperBound=" + this.partitionUpperBound + ", partitionLowerBound=" + this.partitionLowerBound + ", fetchSize=" + this.fetchSize + ", partitionNumber=" + this.partitionNumber + ")";
        }
    }
}

