/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeMapper;

public class OracleDialect
implements JdbcDialect {
    private static final int DEFAULT_ORACLE_FETCH_SIZE = 128;

    @Override
    public String dialectName() {
        return "Oracle";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new OracleJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new OracleTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteIdentifier(tableName);
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s FROM DUAL", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format(" MERGE INTO %s TARGET USING (%s) SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", this.tableIdentifier(database, tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(128);
        }
        return statement;
    }
}

