/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;

public class SapHanaTypeMapper
implements JdbcDialectTypeMapper {
    private static final String SAP_HANA_BLOB = "blob";
    private static final String SAP_HANA_VARBINARY = "varbinary";
    private static final String SAP_HANA_DATE = "date";
    private static final String SAP_HANA_TIME = "time";
    private static final String SAP_HANA_LONGDATE = "longtime";
    private static final String SAP_HANA_SECONDDATE = "seconddate";
    private static final String SAP_HANA_TIMESTAMP = "timestamp";
    private static final String SAP_HANA_DECIMAL = "decimal";
    private static final String SAP_HANA_REAL = "real";
    private static final String SAP_HANA_SMALLDECIMAL = "smalldecimal";
    private static final String SAP_HANA_BIGINT = "bigint";
    private static final String SAP_HANA_INTEGER = "integer";
    private static final String SAP_HANA_SMALLINT = "smallint";
    private static final String SAP_HANA_TINYINT = "tinyint";
    private static final String SAP_HANA_DOUBLE = "double";
    private static final String SAP_HANA_CLOB = "clob";
    private static final String SAP_HANA_NCLOB = "nclob";
    private static final String SAP_HANA_TEXT = "text";
    private static final String SAP_HANA_ALPHANUM = "alphanum";
    private static final String SAP_HANA_NVARCHAR = "nvarchar";
    private static final String SAP_HANA_SHORTTEXT = "shorttext";
    private static final String SAP_HANA_VARCHAR = "varchar";
    private static final String SAP_HANA_BINARY = "binary";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String typeName = metadata.getColumnTypeName(colIndex).toLowerCase(Locale.ROOT);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (typeName) {
            case "blob": 
            case "varbinary": 
            case "binary": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "date": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "time": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "timestamp": 
            case "longtime": 
            case "seconddate": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "decimal": {
                return new DecimalType(precision, scale);
            }
            case "real": 
            case "smalldecimal": {
                return BasicType.FLOAT_TYPE;
            }
            case "bigint": {
                return BasicType.LONG_TYPE;
            }
            case "integer": {
                return BasicType.INT_TYPE;
            }
            case "smallint": {
                return BasicType.SHORT_TYPE;
            }
            case "tinyint": {
                return BasicType.BYTE_TYPE;
            }
            case "double": {
                return BasicType.DOUBLE_TYPE;
            }
            case "clob": 
            case "nclob": 
            case "text": 
            case "alphanum": 
            case "nvarchar": 
            case "shorttext": 
            case "varchar": {
                return BasicType.STRING_TYPE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw new UnsupportedOperationException(String.format("Doesn't support SapHana type '%s' on column '%s'  yet.", typeName, jdbcColumnName));
    }
}

