/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlserverTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(SqlserverTypeMapper.class);
    private static final String SQLSERVER_UNKNOWN = "UNKNOWN";
    private static final String SQLSERVER_BIT = "BIT";
    private static final String SQLSERVER_TINYINT = "TINYINT";
    private static final String SQLSERVER_SMALLINT = "SMALLINT";
    private static final String SQLSERVER_INTEGER = "INTEGER";
    private static final String SQLSERVER_INT = "INT";
    private static final String SQLSERVER_BIGINT = "BIGINT";
    private static final String SQLSERVER_DECIMAL = "DECIMAL";
    private static final String SQLSERVER_FLOAT = "FLOAT";
    private static final String SQLSERVER_REAL = "REAL";
    private static final String SQLSERVER_NUMERIC = "NUMERIC";
    private static final String SQLSERVER_MONEY = "MONEY";
    private static final String SQLSERVER_SMALLMONEY = "SMALLMONEY";
    private static final String SQLSERVER_CHAR = "CHAR";
    private static final String SQLSERVER_VARCHAR = "VARCHAR";
    private static final String SQLSERVER_NTEXT = "NTEXT";
    private static final String SQLSERVER_NCHAR = "NCHAR";
    private static final String SQLSERVER_NVARCHAR = "NVARCHAR";
    private static final String SQLSERVER_TEXT = "TEXT";
    private static final String SQLSERVER_DATE = "DATE";
    private static final String SQLSERVER_TIME = "TIME";
    private static final String SQLSERVER_DATETIME = "DATETIME";
    private static final String SQLSERVER_DATETIME2 = "DATETIME2";
    private static final String SQLSERVER_SMALLDATETIME = "SMALLDATETIME";
    private static final String SQLSERVER_DATETIMEOFFSET = "DATETIMEOFFSET";
    private static final String SQLSERVER_TIMESTAMP = "TIMESTAMP";
    private static final String SQLSERVER_BINARY = "BINARY";
    private static final String SQLSERVER_VARBINARY = "VARBINARY";
    private static final String SQLSERVER_IMAGE = "IMAGE";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String sqlServerType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (sqlServerType) {
            case "BIT": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": 
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INTEGER": 
            case "INT": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": 
            case "NUMERIC": 
            case "MONEY": 
            case "SMALLMONEY": {
                return new DecimalType(precision, scale);
            }
            case "REAL": {
                return BasicType.FLOAT_TYPE;
            }
            case "FLOAT": {
                return BasicType.DOUBLE_TYPE;
            }
            case "CHAR": 
            case "NCHAR": 
            case "VARCHAR": 
            case "NTEXT": 
            case "NVARCHAR": 
            case "TEXT": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATETIME": 
            case "DATETIME2": 
            case "SMALLDATETIME": 
            case "DATETIMEOFFSET": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "TIMESTAMP": 
            case "BINARY": 
            case "VARBINARY": 
            case "IMAGE": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Doesn't support SQLSERVER type '%s' on column '%s'  yet.", sqlServerType, jdbcColumnName));
    }
}

