/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XidGenerator;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XidImpl;

class SemanticXidGenerator
implements XidGenerator {
    private static final long serialVersionUID = 1L;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final int JOB_ID_BYTES = 32;
    private static final int FORMAT_ID = 201;
    private transient byte[] gtridBuffer;
    private transient byte[] bqualBuffer;

    SemanticXidGenerator() {
    }

    @Override
    public void open() {
        this.gtridBuffer = new byte[44];
        this.bqualBuffer = this.getRandomBytes(4);
    }

    @Override
    public Xid generateXid(JobContext context, SinkWriter.Context sinkContext, long checkpointId) {
        byte[] jobIdBytes = context.getJobId().getBytes();
        Arrays.fill(this.gtridBuffer, (byte)0);
        Preconditions.checkArgument(jobIdBytes.length <= 32);
        System.arraycopy(jobIdBytes, 0, this.gtridBuffer, 0, jobIdBytes.length);
        SemanticXidGenerator.writeNumber(sinkContext.getIndexOfSubtask(), 4, this.gtridBuffer, 32);
        SemanticXidGenerator.writeNumber(checkpointId, 8, this.gtridBuffer, 36);
        return new XidImpl(201, this.gtridBuffer, this.bqualBuffer);
    }

    @Override
    public boolean belongsToSubtask(Xid xid, JobContext context, SinkWriter.Context sinkContext) {
        if (xid.getFormatId() != 201) {
            return false;
        }
        int xidSubtaskIndex = SemanticXidGenerator.readNumber(xid.getGlobalTransactionId(), 32, 4);
        if (xidSubtaskIndex != sinkContext.getIndexOfSubtask()) {
            return false;
        }
        byte[] xidJobIdBytes = new byte[32];
        System.arraycopy(xid.getGlobalTransactionId(), 0, xidJobIdBytes, 0, 32);
        byte[] jobIdBytes = new byte[32];
        byte[] bytes = context.getJobId().getBytes();
        System.arraycopy(bytes, 0, jobIdBytes, 0, bytes.length);
        return Arrays.equals(jobIdBytes, xidJobIdBytes);
    }

    private static int readNumber(byte[] bytes, int offset, int numBytes) {
        int number = 255;
        int result = 0;
        for (int i = 0; i < numBytes; ++i) {
            result |= (bytes[offset + i] & 0xFF) << 8 * i;
        }
        return result;
    }

    private static void writeNumber(long number, int numBytes, byte[] dst, int dstOffset) {
        for (int i = dstOffset; i < dstOffset + numBytes; ++i) {
            dst[i] = (byte)number;
            number >>>= 8;
        }
    }

    private byte[] getRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }
}

