/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.network.ServerException;
import io.debezium.DebeziumException;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.pipeline.ErrorHandler;
import java.sql.SQLException;

public class MySqlErrorHandler
extends ErrorHandler {
    private static final String SQL_CODE_TOO_MANY_CONNECTIONS = "08004";

    public MySqlErrorHandler(String logicalName, ChangeEventQueue<?> queue) {
        super(MySqlConnector.class, logicalName, queue);
    }

    @Override
    protected boolean isRetriable(Throwable throwable) {
        if (throwable instanceof SQLException) {
            SQLException sql = (SQLException)throwable;
            return SQL_CODE_TOO_MANY_CONNECTIONS.equals(sql.getSQLState());
        }
        if (throwable instanceof ServerException) {
            ServerException sql = (ServerException)throwable;
            return SQL_CODE_TOO_MANY_CONNECTIONS.equals(sql.getSqlState());
        }
        if (throwable instanceof DebeziumException && throwable.getCause() != null) {
            return this.isRetriable(throwable.getCause());
        }
        return false;
    }
}

