/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import com.mysql.cj.CharsetMapping;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, converters, tableFilter);
    }

    protected MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    @Override
    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser(commonTokenStream);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 207), new DataTypeResolver.DataTypeEntry(12, 207, 223), new DataTypeResolver.DataTypeEntry(12, 208), new DataTypeResolver.DataTypeEntry(12, 218), new DataTypeResolver.DataTypeEntry(12, 219), new DataTypeResolver.DataTypeEntry(12, 220), new DataTypeResolver.DataTypeEntry(12, 221), new DataTypeResolver.DataTypeEntry(-15, 483), new DataTypeResolver.DataTypeEntry(-9, 483, 223), new DataTypeResolver.DataTypeEntry(-9, 209), new DataTypeResolver.DataTypeEntry(-2, 207, 211), new DataTypeResolver.DataTypeEntry(-2, 208, 211), new DataTypeResolver.DataTypeEntry(-2, 218, 211), new DataTypeResolver.DataTypeEntry(-2, 219, 211), new DataTypeResolver.DataTypeEntry(-2, 220, 211), new DataTypeResolver.DataTypeEntry(-2, 221, 211), new DataTypeResolver.DataTypeEntry(-2, 483, 211), new DataTypeResolver.DataTypeEntry(-2, 209, 211), new DataTypeResolver.DataTypeEntry(1, 22), new DataTypeResolver.DataTypeEntry(12, 22, 223)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 210, 208).setSuffixTokens(211), new DataTypeResolver.DataTypeEntry(-15, 210, 22).setSuffixTokens(211), new DataTypeResolver.DataTypeEntry(-9, 483, 208).setSuffixTokens(211)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 210, 207, 223), new DataTypeResolver.DataTypeEntry(-9, 210, 22, 223)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, 181).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(5, 186).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(5, 182).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(5, 187).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(4, 183).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(4, 188).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(4, 184).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(4, 185).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(4, 191).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(4, 189).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(-5, 192).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(-5, 190).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(7, 193).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(8, 194).setSuffixTokens(195, 564, 168, 180), new DataTypeResolver.DataTypeEntry(8, 198).setSuffixTokens(195, 564, 168, 180), new DataTypeResolver.DataTypeEntry(6, 196).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(6, 197).setSuffixTokens(564, 168, 180), new DataTypeResolver.DataTypeEntry(3, 199).setSuffixTokens(564, 168, 180).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 200).setSuffixTokens(564, 168, 180).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 398).setSuffixTokens(564, 168, 180).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, 201).setSuffixTokens(564, 168, 180).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, 317), new DataTypeResolver.DataTypeEntry(92, 203), new DataTypeResolver.DataTypeEntry(2014, 204), new DataTypeResolver.DataTypeEntry(93, 205), new DataTypeResolver.DataTypeEntry(-2, 211), new DataTypeResolver.DataTypeEntry(-3, 212), new DataTypeResolver.DataTypeEntry(2004, 214), new DataTypeResolver.DataTypeEntry(4, 206)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, 202), new DataTypeResolver.DataTypeEntry(2004, 213), new DataTypeResolver.DataTypeEntry(2004, 215), new DataTypeResolver.DataTypeEntry(2004, 217), new DataTypeResolver.DataTypeEntry(16, 319), new DataTypeResolver.DataTypeEntry(16, 320), new DataTypeResolver.DataTypeEntry(-5, 224)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 222).setSuffixTokens(211), new DataTypeResolver.DataTypeEntry(1, 141).setSuffixTokens(211)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, 744), new DataTypeResolver.DataTypeEntry(1111, 745), new DataTypeResolver.DataTypeEntry(1111, 747), new DataTypeResolver.DataTypeEntry(1111, 748), new DataTypeResolver.DataTypeEntry(1111, 749), new DataTypeResolver.DataTypeEntry(1111, 750), new DataTypeResolver.DataTypeEntry(1111, 751), new DataTypeResolver.DataTypeEntry(1111, 752), new DataTypeResolver.DataTypeEntry(1111, 431), new DataTypeResolver.DataTypeEntry(1111, 746)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, 216).setSuffixTokens(212)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, 216).setSuffixTokens(208)));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes(uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote(c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && ce.defaultValue() == null) {
                    ce.unsetDefaultValue();
                }
                tableEditor.addColumn(ce.create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MySqlParser.CharsetNameContext charsetNode, MySqlParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MySqlAntlrDdlParser.withoutQuotes(charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MySqlAntlrDdlParser.withoutQuotes(collationNode.getText()).toLowerCase();
            for (int index = 0; index < 1024; ++index) {
                if (!collationName.equals(CharsetMapping.getStaticCollationNameForCollationIndex((Integer)index))) continue;
                charsetName = CharsetMapping.getStaticMysqlCharsetNameForCollationIndex((Integer)index);
                break;
            }
        }
        return charsetName;
    }
}

