/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Values {
    private static final Logger LOG = LoggerFactory.getLogger(Values.class);
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final SchemaAndValue NULL_SCHEMA_AND_VALUE = new SchemaAndValue(null, null);
    private static final SchemaAndValue TRUE_SCHEMA_AND_VALUE = new SchemaAndValue(Schema.BOOLEAN_SCHEMA, Boolean.TRUE);
    private static final SchemaAndValue FALSE_SCHEMA_AND_VALUE = new SchemaAndValue(Schema.BOOLEAN_SCHEMA, Boolean.FALSE);
    private static final Schema ARRAY_SELECTOR_SCHEMA = SchemaBuilder.array(Schema.STRING_SCHEMA).build();
    private static final Schema MAP_SELECTOR_SCHEMA = SchemaBuilder.map(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA).build();
    private static final Schema STRUCT_SELECTOR_SCHEMA = SchemaBuilder.struct().build();
    private static final String TRUE_LITERAL = Boolean.TRUE.toString();
    private static final String FALSE_LITERAL = Boolean.FALSE.toString();
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final String NULL_VALUE = "null";
    static final String ISO_8601_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    static final String ISO_8601_TIME_FORMAT_PATTERN = "HH:mm:ss.SSS'Z'";
    static final String ISO_8601_TIMESTAMP_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Set<String> TEMPORAL_LOGICAL_TYPE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.apache.kafka.connect.data.Time", "org.apache.kafka.connect.data.Timestamp", "org.apache.kafka.connect.data.Date")));
    private static final String QUOTE_DELIMITER = "\"";
    private static final String COMMA_DELIMITER = ",";
    private static final String ENTRY_DELIMITER = ":";
    private static final String ARRAY_BEGIN_DELIMITER = "[";
    private static final String ARRAY_END_DELIMITER = "]";
    private static final String MAP_BEGIN_DELIMITER = "{";
    private static final String MAP_END_DELIMITER = "}";
    private static final int ISO_8601_DATE_LENGTH = "yyyy-MM-dd".length();
    private static final int ISO_8601_TIME_LENGTH = "HH:mm:ss.SSS'Z'".length() - 2;
    private static final int ISO_8601_TIMESTAMP_LENGTH = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length() - 4;
    private static final Pattern TWO_BACKSLASHES = Pattern.compile("\\\\");
    private static final Pattern DOUBLEQOUTE = Pattern.compile("\"");

    public static Boolean convertToBoolean(Schema schema, Object value) throws DataException {
        return (Boolean)Values.convertTo(Schema.OPTIONAL_BOOLEAN_SCHEMA, schema, value);
    }

    public static Byte convertToByte(Schema schema, Object value) throws DataException {
        return (Byte)Values.convertTo(Schema.OPTIONAL_INT8_SCHEMA, schema, value);
    }

    public static Short convertToShort(Schema schema, Object value) throws DataException {
        return (Short)Values.convertTo(Schema.OPTIONAL_INT16_SCHEMA, schema, value);
    }

    public static Integer convertToInteger(Schema schema, Object value) throws DataException {
        return (Integer)Values.convertTo(Schema.OPTIONAL_INT32_SCHEMA, schema, value);
    }

    public static Long convertToLong(Schema schema, Object value) throws DataException {
        return (Long)Values.convertTo(Schema.OPTIONAL_INT64_SCHEMA, schema, value);
    }

    public static Float convertToFloat(Schema schema, Object value) throws DataException {
        return (Float)Values.convertTo(Schema.OPTIONAL_FLOAT32_SCHEMA, schema, value);
    }

    public static Double convertToDouble(Schema schema, Object value) throws DataException {
        return (Double)Values.convertTo(Schema.OPTIONAL_FLOAT64_SCHEMA, schema, value);
    }

    public static String convertToString(Schema schema, Object value) {
        return (String)Values.convertTo(Schema.OPTIONAL_STRING_SCHEMA, schema, value);
    }

    public static List<?> convertToList(Schema schema, Object value) {
        return (List)Values.convertTo(ARRAY_SELECTOR_SCHEMA, schema, value);
    }

    public static Map<?, ?> convertToMap(Schema schema, Object value) {
        return (Map)Values.convertTo(MAP_SELECTOR_SCHEMA, schema, value);
    }

    public static Struct convertToStruct(Schema schema, Object value) {
        return (Struct)Values.convertTo(STRUCT_SELECTOR_SCHEMA, schema, value);
    }

    public static java.util.Date convertToTime(Schema schema, Object value) {
        return (java.util.Date)Values.convertTo(Time.SCHEMA, schema, value);
    }

    public static java.util.Date convertToDate(Schema schema, Object value) {
        return (java.util.Date)Values.convertTo(Date.SCHEMA, schema, value);
    }

    public static java.util.Date convertToTimestamp(Schema schema, Object value) {
        return (java.util.Date)Values.convertTo(Timestamp.SCHEMA, schema, value);
    }

    public static BigDecimal convertToDecimal(Schema schema, Object value, int scale) {
        return (BigDecimal)Values.convertTo(Decimal.schema(scale), schema, value);
    }

    public static Schema inferSchema(Object value) {
        if (value instanceof String) {
            return Schema.STRING_SCHEMA;
        }
        if (value instanceof Boolean) {
            return Schema.BOOLEAN_SCHEMA;
        }
        if (value instanceof Byte) {
            return Schema.INT8_SCHEMA;
        }
        if (value instanceof Short) {
            return Schema.INT16_SCHEMA;
        }
        if (value instanceof Integer) {
            return Schema.INT32_SCHEMA;
        }
        if (value instanceof Long) {
            return Schema.INT64_SCHEMA;
        }
        if (value instanceof Float) {
            return Schema.FLOAT32_SCHEMA;
        }
        if (value instanceof Double) {
            return Schema.FLOAT64_SCHEMA;
        }
        if (value instanceof byte[] || value instanceof ByteBuffer) {
            return Schema.BYTES_SCHEMA;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            SchemaDetector detector = new SchemaDetector();
            for (Object element : list) {
                if (detector.canDetect(element)) continue;
                return null;
            }
            return SchemaBuilder.array(detector.schema()).build();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return null;
            }
            SchemaDetector keyDetector = new SchemaDetector();
            SchemaDetector valueDetector = new SchemaDetector();
            for (Map.Entry entry : map.entrySet()) {
                if (keyDetector.canDetect(entry.getKey()) && valueDetector.canDetect(entry.getValue())) continue;
                return null;
            }
            return SchemaBuilder.map(keyDetector.schema(), valueDetector.schema()).build();
        }
        if (value instanceof Struct) {
            return ((Struct)value).schema();
        }
        return null;
    }

    public static SchemaAndValue parseString(String value) {
        if (value == null) {
            return NULL_SCHEMA_AND_VALUE;
        }
        if (value.isEmpty()) {
            return new SchemaAndValue(Schema.STRING_SCHEMA, value);
        }
        Parser parser = new Parser(value);
        return Values.parse(parser, false);
    }

    protected static Object convertTo(Schema toSchema, Schema fromSchema, Object value) throws DataException {
        if (value == null) {
            if (toSchema.isOptional()) {
                return null;
            }
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        switch (toSchema.type()) {
            case BYTES: {
                if ("org.apache.kafka.connect.data.Decimal".equals(toSchema.name())) {
                    if (value instanceof ByteBuffer) {
                        value = Utils.toArray((ByteBuffer)value);
                    }
                    if (value instanceof byte[]) {
                        return Decimal.toLogical(toSchema, (byte[])value);
                    }
                    if (value instanceof BigDecimal) {
                        return value;
                    }
                    if (value instanceof Number) {
                        double converted = ((Number)value).doubleValue();
                        return BigDecimal.valueOf(converted);
                    }
                    if (value instanceof String) {
                        return new BigDecimal(value.toString()).doubleValue();
                    }
                }
                if (value instanceof ByteBuffer) {
                    return Utils.toArray((ByteBuffer)value);
                }
                if (value instanceof byte[]) {
                    return value;
                }
                if (!(value instanceof BigDecimal)) break;
                return Decimal.fromLogical(toSchema, (BigDecimal)value);
            }
            case STRING: {
                StringBuilder sb = new StringBuilder();
                Values.append(sb, value, false);
                return sb.toString();
            }
            case BOOLEAN: {
                SchemaAndValue parsed;
                if (value instanceof Boolean) {
                    return value;
                }
                if (value instanceof String && (parsed = Values.parseString(value.toString())).value() instanceof Boolean) {
                    return parsed.value();
                }
                return Values.asLong(value, fromSchema, null) == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case INT8: {
                if (value instanceof Byte) {
                    return value;
                }
                return (byte)Values.asLong(value, fromSchema, null);
            }
            case INT16: {
                if (value instanceof Short) {
                    return value;
                }
                return (short)Values.asLong(value, fromSchema, null);
            }
            case INT32: {
                if ("org.apache.kafka.connect.data.Date".equals(toSchema.name())) {
                    if (value instanceof String) {
                        SchemaAndValue parsed = Values.parseString(value.toString());
                        value = parsed.value();
                    }
                    if (value instanceof java.util.Date) {
                        if (fromSchema != null) {
                            String fromSchemaName = fromSchema.name();
                            if ("org.apache.kafka.connect.data.Date".equals(fromSchemaName)) {
                                return value;
                            }
                            if ("org.apache.kafka.connect.data.Timestamp".equals(fromSchemaName)) {
                                long millis = ((java.util.Date)value).getTime();
                                int days = (int)(millis / 86400000L);
                                return Date.toLogical(toSchema, days);
                            }
                        } else {
                            return value;
                        }
                    }
                    long numeric = Values.asLong(value, fromSchema, null);
                    return Date.toLogical(toSchema, (int)numeric);
                }
                if ("org.apache.kafka.connect.data.Time".equals(toSchema.name())) {
                    if (value instanceof String) {
                        SchemaAndValue parsed = Values.parseString(value.toString());
                        value = parsed.value();
                    }
                    if (value instanceof java.util.Date) {
                        if (fromSchema != null) {
                            String fromSchemaName = fromSchema.name();
                            if ("org.apache.kafka.connect.data.Time".equals(fromSchemaName)) {
                                return value;
                            }
                            if ("org.apache.kafka.connect.data.Timestamp".equals(fromSchemaName)) {
                                Calendar calendar = Calendar.getInstance(UTC);
                                calendar.setTime((java.util.Date)value);
                                calendar.set(1, 1970);
                                calendar.set(2, 0);
                                calendar.set(5, 1);
                                return Time.toLogical(toSchema, (int)calendar.getTimeInMillis());
                            }
                        } else {
                            return value;
                        }
                    }
                    long numeric = Values.asLong(value, fromSchema, null);
                    return Time.toLogical(toSchema, (int)numeric);
                }
                if (value instanceof Integer) {
                    return value;
                }
                return (int)Values.asLong(value, fromSchema, null);
            }
            case INT64: {
                if ("org.apache.kafka.connect.data.Timestamp".equals(toSchema.name())) {
                    if (value instanceof String) {
                        SchemaAndValue parsed = Values.parseString(value.toString());
                        value = parsed.value();
                    }
                    if (value instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)value;
                        if (fromSchema != null) {
                            String fromSchemaName = fromSchema.name();
                            if ("org.apache.kafka.connect.data.Date".equals(fromSchemaName)) {
                                int days = Date.fromLogical(fromSchema, date);
                                long millis = (long)days * 86400000L;
                                return Timestamp.toLogical(toSchema, millis);
                            }
                            if ("org.apache.kafka.connect.data.Time".equals(fromSchemaName)) {
                                long millis = Time.fromLogical(fromSchema, date);
                                return Timestamp.toLogical(toSchema, millis);
                            }
                            if ("org.apache.kafka.connect.data.Timestamp".equals(fromSchemaName)) {
                                return value;
                            }
                        } else {
                            return value;
                        }
                    }
                    long numeric = Values.asLong(value, fromSchema, null);
                    return Timestamp.toLogical(toSchema, numeric);
                }
                if (value instanceof Long) {
                    return value;
                }
                return Values.asLong(value, fromSchema, null);
            }
            case FLOAT32: {
                if (value instanceof Float) {
                    return value;
                }
                return Float.valueOf((float)Values.asDouble(value, fromSchema, null));
            }
            case FLOAT64: {
                if (value instanceof Double) {
                    return value;
                }
                return Values.asDouble(value, fromSchema, null);
            }
            case ARRAY: {
                if (value instanceof String) {
                    SchemaAndValue schemaAndValue = Values.parseString(value.toString());
                    value = schemaAndValue.value();
                }
                if (!(value instanceof List)) break;
                return value;
            }
            case MAP: {
                if (value instanceof String) {
                    SchemaAndValue schemaAndValue = Values.parseString(value.toString());
                    value = schemaAndValue.value();
                }
                if (!(value instanceof Map)) break;
                return value;
            }
            case STRUCT: {
                if (!(value instanceof Struct)) break;
                Struct struct = (Struct)value;
                return struct;
            }
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    protected static long asLong(Object value, Schema fromSchema, Throwable error) {
        try {
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.longValue();
            }
            if (value instanceof String) {
                return new BigDecimal(value.toString()).longValue();
            }
        }
        catch (NumberFormatException e) {
            error = e;
        }
        if (fromSchema != null) {
            String schemaName = fromSchema.name();
            if (value instanceof java.util.Date) {
                if ("org.apache.kafka.connect.data.Date".equals(schemaName)) {
                    return Date.fromLogical(fromSchema, (java.util.Date)value);
                }
                if ("org.apache.kafka.connect.data.Time".equals(schemaName)) {
                    return Time.fromLogical(fromSchema, (java.util.Date)value);
                }
                if ("org.apache.kafka.connect.data.Timestamp".equals(schemaName)) {
                    return Timestamp.fromLogical(fromSchema, (java.util.Date)value);
                }
            }
            throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + fromSchema, error);
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to a number", error);
    }

    protected static double asDouble(Object value, Schema schema, Throwable error) {
        try {
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.doubleValue();
            }
            if (value instanceof String) {
                return new BigDecimal(value.toString()).doubleValue();
            }
        }
        catch (NumberFormatException e) {
            error = e;
        }
        return Values.asLong(value, schema, error);
    }

    protected static void append(StringBuilder sb, Object value, boolean embedded) {
        if (value == null) {
            sb.append(NULL_VALUE);
        } else if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof Boolean) {
            sb.append(value);
        } else if (value instanceof String) {
            if (embedded) {
                String escaped = Values.escape((String)value);
                sb.append('\"').append(escaped).append('\"');
            } else {
                sb.append(value);
            }
        } else if (value instanceof byte[]) {
            value = Base64.getEncoder().encodeToString((byte[])value);
            if (embedded) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
        } else if (value instanceof ByteBuffer) {
            byte[] bytes = Utils.readBytes((ByteBuffer)value);
            Values.append(sb, bytes, embedded);
        } else if (value instanceof List) {
            List list = (List)value;
            sb.append('[');
            Values.appendIterable(sb, list.iterator());
            sb.append(']');
        } else if (value instanceof Map) {
            Map map = (Map)value;
            sb.append('{');
            Values.appendIterable(sb, map.entrySet().iterator());
            sb.append('}');
        } else if (value instanceof Struct) {
            Struct struct = (Struct)value;
            Schema schema = struct.schema();
            boolean first = true;
            sb.append('{');
            for (Field field : schema.fields()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                Values.append(sb, field.name(), true);
                sb.append(':');
                Values.append(sb, struct.get(field), true);
            }
            sb.append('}');
        } else if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            Values.append(sb, entry.getKey(), true);
            sb.append(':');
            Values.append(sb, entry.getValue(), true);
        } else if (value instanceof java.util.Date) {
            java.util.Date dateValue = (java.util.Date)value;
            String formatted = Values.dateFormatFor(dateValue).format(dateValue);
            sb.append(formatted);
        } else {
            throw new DataException("Failed to serialize unexpected value type " + value.getClass().getName() + ": " + value);
        }
    }

    protected static void appendIterable(StringBuilder sb, Iterator<?> iter) {
        if (iter.hasNext()) {
            Values.append(sb, iter.next(), true);
            while (iter.hasNext()) {
                sb.append(',');
                Values.append(sb, iter.next(), true);
            }
        }
    }

    protected static String escape(String value) {
        String replace1 = TWO_BACKSLASHES.matcher(value).replaceAll("\\\\\\\\");
        return DOUBLEQOUTE.matcher(replace1).replaceAll("\\\\\"");
    }

    public static DateFormat dateFormatFor(java.util.Date value) {
        if (value.getTime() < 86400000L) {
            return new SimpleDateFormat(ISO_8601_TIME_FORMAT_PATTERN);
        }
        if (value.getTime() % 86400000L == 0L) {
            return new SimpleDateFormat(ISO_8601_DATE_FORMAT_PATTERN);
        }
        return new SimpleDateFormat(ISO_8601_TIMESTAMP_FORMAT_PATTERN);
    }

    protected static boolean canParseSingleTokenLiteral(Parser parser, boolean embedded, String tokenLiteral) {
        int startPosition = parser.mark();
        if (parser.canConsume(tokenLiteral) && (embedded || !parser.hasNext())) {
            return true;
        }
        parser.rewindTo(startPosition);
        return false;
    }

    protected static SchemaAndValue parse(Parser parser, boolean embedded) throws NoSuchElementException {
        if (!parser.hasNext()) {
            return null;
        }
        if (embedded && parser.canConsume(QUOTE_DELIMITER)) {
            StringBuilder sb = new StringBuilder();
            while (parser.hasNext() && !parser.canConsume(QUOTE_DELIMITER)) {
                sb.append(parser.next());
            }
            String content = sb.toString();
            SchemaAndValue parsed = Values.parseString(content);
            if (parsed != null && TEMPORAL_LOGICAL_TYPE_NAMES.contains(parsed.schema().name())) {
                return parsed;
            }
            return new SchemaAndValue(Schema.STRING_SCHEMA, content);
        }
        if (Values.canParseSingleTokenLiteral(parser, embedded, NULL_VALUE)) {
            return null;
        }
        if (Values.canParseSingleTokenLiteral(parser, embedded, TRUE_LITERAL)) {
            return TRUE_SCHEMA_AND_VALUE;
        }
        if (Values.canParseSingleTokenLiteral(parser, embedded, FALSE_LITERAL)) {
            return FALSE_SCHEMA_AND_VALUE;
        }
        int startPosition = parser.mark();
        try {
            if (parser.canConsume(ARRAY_BEGIN_DELIMITER)) {
                List<Object> result = new ArrayList<Object>();
                Schema elementSchema = null;
                while (parser.hasNext()) {
                    if (parser.canConsume(ARRAY_END_DELIMITER)) {
                        Schema listSchema;
                        if (elementSchema != null) {
                            listSchema = SchemaBuilder.array(elementSchema).schema();
                            result = Values.alignListEntriesWithSchema(listSchema, result);
                        } else {
                            listSchema = SchemaBuilder.arrayOfNull().build();
                        }
                        return new SchemaAndValue(listSchema, result);
                    }
                    if (parser.canConsume(COMMA_DELIMITER)) {
                        throw new DataException("Unable to parse an empty array element: " + parser.original());
                    }
                    SchemaAndValue element = Values.parse(parser, true);
                    elementSchema = Values.commonSchemaFor(elementSchema, element);
                    result.add(element != null ? element.value() : null);
                    int currentPosition = parser.mark();
                    if (parser.canConsume(ARRAY_END_DELIMITER)) {
                        parser.rewindTo(currentPosition);
                        continue;
                    }
                    if (parser.canConsume(COMMA_DELIMITER)) continue;
                    throw new DataException("Array elements missing ',' delimiter");
                }
                if (COMMA_DELIMITER.equals(parser.previous())) {
                    throw new DataException("Array is missing element after ',': " + parser.original());
                }
                throw new DataException("Array is missing terminating ']': " + parser.original());
            }
            if (parser.canConsume(MAP_BEGIN_DELIMITER)) {
                Map<Object, Object> result = new LinkedHashMap<Object, Object>();
                Schema keySchema = null;
                Schema valueSchema = null;
                while (parser.hasNext()) {
                    if (parser.canConsume(MAP_END_DELIMITER)) {
                        Schema mapSchema;
                        if (keySchema != null && valueSchema != null) {
                            mapSchema = SchemaBuilder.map(keySchema, valueSchema).build();
                            result = Values.alignMapKeysAndValuesWithSchema(mapSchema, result);
                        } else if (keySchema != null) {
                            mapSchema = SchemaBuilder.mapWithNullValues(keySchema);
                            result = Values.alignMapKeysWithSchema(mapSchema, result);
                        } else {
                            mapSchema = SchemaBuilder.mapOfNull().build();
                        }
                        return new SchemaAndValue(mapSchema, result);
                    }
                    if (parser.canConsume(COMMA_DELIMITER)) {
                        throw new DataException("Unable to parse a map entry with no key or value: " + parser.original());
                    }
                    SchemaAndValue key = Values.parse(parser, true);
                    if (key == null || key.value() == null) {
                        throw new DataException("Map entry may not have a null key: " + parser.original());
                    }
                    if (!parser.canConsume(ENTRY_DELIMITER)) {
                        throw new DataException("Map entry is missing ':' at " + parser.position() + " in " + parser.original());
                    }
                    SchemaAndValue value = Values.parse(parser, true);
                    Object entryValue = value != null ? value.value() : null;
                    result.put(key.value(), entryValue);
                    parser.canConsume(COMMA_DELIMITER);
                    keySchema = Values.commonSchemaFor(keySchema, key);
                    valueSchema = Values.commonSchemaFor(valueSchema, value);
                }
                if (COMMA_DELIMITER.equals(parser.previous())) {
                    throw new DataException("Map is missing element after ',': " + parser.original());
                }
                throw new DataException("Map is missing terminating '}': " + parser.original());
            }
        }
        catch (DataException e) {
            LOG.trace("Unable to parse the value as a map or an array; reverting to string", (Throwable)e);
            parser.rewindTo(startPosition);
        }
        String token = parser.next();
        if (token.trim().isEmpty()) {
            return new SchemaAndValue(Schema.STRING_SCHEMA, token);
        }
        char firstChar = (token = token.trim()).charAt(0);
        boolean firstCharIsDigit = Character.isDigit(firstChar);
        if (firstCharIsDigit) {
            String timeOrTimestampStr;
            SchemaAndValue temporal;
            int position = parser.mark();
            String remainder222 = parser.next(4);
            if (remainder222 != null && (temporal = Values.parseAsTemporal(timeOrTimestampStr = token + remainder222)) != null) {
                return temporal;
            }
            parser.rewindTo(position);
            SchemaAndValue temporal2 = Values.parseAsTemporal(token);
            if (temporal2 != null) {
                return temporal2;
            }
        }
        if (firstCharIsDigit || firstChar == '+' || firstChar == '-') {
            try {
                BigDecimal decimal = new BigDecimal(token);
                try {
                    return new SchemaAndValue(Schema.INT8_SCHEMA, decimal.byteValueExact());
                }
                catch (ArithmeticException remainder222) {
                    try {
                        return new SchemaAndValue(Schema.INT16_SCHEMA, decimal.shortValueExact());
                    }
                    catch (ArithmeticException remainder222) {
                        try {
                            return new SchemaAndValue(Schema.INT32_SCHEMA, decimal.intValueExact());
                        }
                        catch (ArithmeticException remainder222) {
                            try {
                                return new SchemaAndValue(Schema.INT64_SCHEMA, decimal.longValueExact());
                            }
                            catch (ArithmeticException remainder222) {
                                float fValue = decimal.floatValue();
                                if (fValue != Float.NEGATIVE_INFINITY && fValue != Float.POSITIVE_INFINITY && decimal.scale() != 0) {
                                    return new SchemaAndValue(Schema.FLOAT32_SCHEMA, Float.valueOf(fValue));
                                }
                                double dValue = decimal.doubleValue();
                                if (dValue != Double.NEGATIVE_INFINITY && dValue != Double.POSITIVE_INFINITY && decimal.scale() != 0) {
                                    return new SchemaAndValue(Schema.FLOAT64_SCHEMA, dValue);
                                }
                                Schema schema = Decimal.schema(decimal.scale());
                                return new SchemaAndValue(schema, decimal);
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (embedded) {
            throw new DataException("Failed to parse embedded value");
        }
        return new SchemaAndValue(Schema.STRING_SCHEMA, parser.original());
    }

    private static SchemaAndValue parseAsTemporal(String token) {
        if (token == null) {
            return null;
        }
        int tokenLength = (token = token.replace("\\:", ENTRY_DELIMITER)).length();
        if (tokenLength == ISO_8601_TIME_LENGTH) {
            try {
                return new SchemaAndValue(Time.SCHEMA, new SimpleDateFormat(ISO_8601_TIME_FORMAT_PATTERN).parse(token));
            }
            catch (ParseException parseException) {
            }
        } else if (tokenLength == ISO_8601_TIMESTAMP_LENGTH) {
            try {
                return new SchemaAndValue(Timestamp.SCHEMA, new SimpleDateFormat(ISO_8601_TIMESTAMP_FORMAT_PATTERN).parse(token));
            }
            catch (ParseException parseException) {
            }
        } else if (tokenLength == ISO_8601_DATE_LENGTH) {
            try {
                return new SchemaAndValue(Date.SCHEMA, new SimpleDateFormat(ISO_8601_DATE_FORMAT_PATTERN).parse(token));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static Schema commonSchemaFor(Schema previous, SchemaAndValue latest) {
        Schema.Type newType;
        if (latest == null) {
            return previous;
        }
        if (previous == null) {
            return latest.schema();
        }
        Schema newSchema = latest.schema();
        Schema.Type previousType = previous.type();
        if (previousType != (newType = newSchema.type())) {
            switch (previous.type()) {
                case INT8: {
                    if (newType != Schema.Type.INT16 && newType != Schema.Type.INT32 && newType != Schema.Type.INT64 && newType != Schema.Type.FLOAT32 && newType != Schema.Type.FLOAT64) break;
                    return newSchema;
                }
                case INT16: {
                    if (newType == Schema.Type.INT8) {
                        return previous;
                    }
                    if (newType != Schema.Type.INT32 && newType != Schema.Type.INT64 && newType != Schema.Type.FLOAT32 && newType != Schema.Type.FLOAT64) break;
                    return newSchema;
                }
                case INT32: {
                    if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16) {
                        return previous;
                    }
                    if (newType != Schema.Type.INT64 && newType != Schema.Type.FLOAT32 && newType != Schema.Type.FLOAT64) break;
                    return newSchema;
                }
                case INT64: {
                    if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16 || newType == Schema.Type.INT32) {
                        return previous;
                    }
                    if (newType != Schema.Type.FLOAT32 && newType != Schema.Type.FLOAT64) break;
                    return newSchema;
                }
                case FLOAT32: {
                    if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16 || newType == Schema.Type.INT32 || newType == Schema.Type.INT64) {
                        return previous;
                    }
                    if (newType != Schema.Type.FLOAT64) break;
                    return newSchema;
                }
                case FLOAT64: {
                    if (newType != Schema.Type.INT8 && newType != Schema.Type.INT16 && newType != Schema.Type.INT32 && newType != Schema.Type.INT64 && newType != Schema.Type.FLOAT32) break;
                    return previous;
                }
            }
            return null;
        }
        if (previous.isOptional() == newSchema.isOptional()) {
            return previous.isOptional() ? previous : newSchema;
        }
        if (!previous.equals(newSchema)) {
            return null;
        }
        return previous;
    }

    protected static List<Object> alignListEntriesWithSchema(Schema schema, List<Object> input) {
        Schema valueSchema = schema.valueSchema();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : input) {
            Object newValue = Values.convertTo(valueSchema, null, value);
            result.add(newValue);
        }
        return result;
    }

    protected static Map<Object, Object> alignMapKeysAndValuesWithSchema(Schema mapSchema, Map<Object, Object> input) {
        Schema keySchema = mapSchema.keySchema();
        Schema valueSchema = mapSchema.valueSchema();
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : input.entrySet()) {
            Object newKey = Values.convertTo(keySchema, null, entry.getKey());
            Object newValue = Values.convertTo(valueSchema, null, entry.getValue());
            result.put(newKey, newValue);
        }
        return result;
    }

    protected static Map<Object, Object> alignMapKeysWithSchema(Schema mapSchema, Map<Object, Object> input) {
        Schema keySchema = mapSchema.keySchema();
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : input.entrySet()) {
            Object newKey = Values.convertTo(keySchema, null, entry.getKey());
            result.put(newKey, entry.getValue());
        }
        return result;
    }

    protected static class Parser {
        private final String original;
        private final CharacterIterator iter;
        private String nextToken = null;
        private String previousToken = null;

        public Parser(String original) {
            this.original = original;
            this.iter = new StringCharacterIterator(this.original);
        }

        public int position() {
            return this.iter.getIndex();
        }

        public int mark() {
            return this.iter.getIndex() - (this.nextToken != null ? this.nextToken.length() : 0);
        }

        public void rewindTo(int position) {
            this.iter.setIndex(position);
            this.nextToken = null;
            this.previousToken = null;
        }

        public String original() {
            return this.original;
        }

        public boolean hasNext() {
            return this.nextToken != null || this.canConsumeNextToken();
        }

        protected boolean canConsumeNextToken() {
            return this.iter.getEndIndex() > this.iter.getIndex();
        }

        public String next() {
            if (this.nextToken != null) {
                this.previousToken = this.nextToken;
                this.nextToken = null;
            } else {
                this.previousToken = this.consumeNextToken();
            }
            return this.previousToken;
        }

        public String next(int n) {
            int current = this.mark();
            int start = this.mark();
            for (int i = 0; i != n; ++i) {
                if (!this.hasNext()) {
                    this.rewindTo(start);
                    return null;
                }
                this.next();
            }
            return this.original.substring(current, this.position());
        }

        private String consumeNextToken() throws NoSuchElementException {
            boolean escaped = false;
            int start = this.iter.getIndex();
            char c = this.iter.current();
            while (this.canConsumeNextToken()) {
                switch (c) {
                    case '\\': {
                        escaped = !escaped;
                        break;
                    }
                    case '\"': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        if (!escaped) {
                            if (start < this.iter.getIndex()) {
                                return this.original.substring(start, this.iter.getIndex());
                            }
                            this.iter.next();
                            return this.original.substring(start, start + 1);
                        }
                        escaped = false;
                        break;
                    }
                    default: {
                        escaped = false;
                    }
                }
                c = this.iter.next();
            }
            return this.original.substring(start, this.iter.getIndex());
        }

        public String previous() {
            return this.previousToken;
        }

        public boolean canConsume(String expected) {
            return this.canConsume(expected, true);
        }

        public boolean canConsume(String expected, boolean ignoreLeadingAndTrailingWhitespace) {
            if (this.isNext(expected, ignoreLeadingAndTrailingWhitespace)) {
                this.nextToken = null;
                return true;
            }
            return false;
        }

        protected boolean isNext(String expected, boolean ignoreLeadingAndTrailingWhitespace) {
            if (this.nextToken == null) {
                if (!this.hasNext()) {
                    return false;
                }
                this.nextToken = this.consumeNextToken();
            }
            if (ignoreLeadingAndTrailingWhitespace) {
                while (this.nextToken.trim().isEmpty() && this.canConsumeNextToken()) {
                    this.nextToken = this.consumeNextToken();
                }
            }
            return ignoreLeadingAndTrailingWhitespace ? this.nextToken.trim().equals(expected) : this.nextToken.equals(expected);
        }
    }

    protected static class SchemaDetector {
        private Schema.Type knownType = null;
        private boolean optional = false;

        public boolean canDetect(Object value) {
            if (value == null) {
                this.optional = true;
                return true;
            }
            Schema schema = Values.inferSchema(value);
            if (schema == null) {
                return false;
            }
            if (this.knownType == null) {
                this.knownType = schema.type();
            } else if (this.knownType != schema.type()) {
                return false;
            }
            return true;
        }

        public Schema schema() {
            SchemaBuilder builder = SchemaBuilder.type(this.knownType);
            if (this.optional) {
                builder.optional();
            }
            return builder.schema();
        }
    }
}

