/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryOffsetBackingStore
implements OffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(MemoryOffsetBackingStore.class);
    protected Map<ByteBuffer, ByteBuffer> data = new HashMap<ByteBuffer, ByteBuffer>();
    protected ExecutorService executor;

    @Override
    public void configure(WorkerConfig config) {
    }

    @Override
    public void start() {
        this.executor = Executors.newFixedThreadPool(1, ThreadUtils.createThreadFactory(this.getClass().getSimpleName() + "-%d", false));
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.executor.shutdownNow().isEmpty()) {
                throw new ConnectException("Failed to stop MemoryOffsetBackingStore. Exiting without cleanly shutting down pending tasks and/or callbacks.");
            }
            this.executor = null;
        }
    }

    @Override
    public Future<Map<ByteBuffer, ByteBuffer>> get(final Collection<ByteBuffer> keys) {
        return this.executor.submit(new Callable<Map<ByteBuffer, ByteBuffer>>(){

            @Override
            public Map<ByteBuffer, ByteBuffer> call() throws Exception {
                HashMap<ByteBuffer, ByteBuffer> result = new HashMap<ByteBuffer, ByteBuffer>();
                for (ByteBuffer key : keys) {
                    result.put(key, MemoryOffsetBackingStore.this.data.get(key));
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> set(final Map<ByteBuffer, ByteBuffer> values, final Callback<Void> callback) {
        return this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Map.Entry entry : values.entrySet()) {
                    MemoryOffsetBackingStore.this.data.put((ByteBuffer)entry.getKey(), (ByteBuffer)entry.getValue());
                }
                MemoryOffsetBackingStore.this.save();
                if (callback != null) {
                    callback.onCompletion(null, null);
                }
                return null;
            }
        });
    }

    protected void save() {
    }
}

