/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.option;

import java.time.ZoneId;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.cdc.base.option.SourceOptions;

public class JdbcSourceOptions
extends SourceOptions {
    public static final Option<String> HOSTNAME = Options.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the database server.");
    public static final Option<Integer> PORT = Options.key((String)"port").intType().defaultValue((Object)3306).withDescription("Integer port number of the database server.");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("Name of the database to use when connecting to the database server.");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the database server.");
    public static final Option<List<String>> DATABASE_NAMES = Options.key((String)"database-names").listType().noDefaultValue().withDescription("Database name of the database to monitor.");
    public static final Option<String> SERVER_TIME_ZONE = Options.key((String)"server-time-zone").stringType().defaultValue((Object)ZoneId.systemDefault().getId()).withDescription("The session time zone in database server.If not set, then ZoneId.systemDefault() is used to determine the server time zone");
    public static final Option<String> SERVER_ID = Options.key((String)"server-id").stringType().noDefaultValue().withDescription("A numeric ID or a numeric ID range of this database client, The numeric ID syntax is like '5400', the numeric ID range syntax is like '5400-5408'. Every ID must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL  cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");
    public static final Option<Long> CONNECT_TIMEOUT_MS = Options.key((String)"connect.timeout.ms").longType().defaultValue((Object)30000L).withDescription("The maximum time that the connector should wait after trying to connect to the database server before timing out.");
    public static final Option<Integer> CONNECTION_POOL_SIZE = Options.key((String)"connection.pool.size").intType().defaultValue((Object)20).withDescription("The connection pool size.");
    public static final Option<Integer> CONNECT_MAX_RETRIES = Options.key((String)"connect.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times that the connector should retry to build database server connection.");
    public static final Option<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = Options.key((String)"chunk-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)100.0).withDescription("The upper bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final Option<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = Options.key((String)"chunk-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withDescription("The lower bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final Option<Integer> SAMPLE_SHARDING_THRESHOLD = Options.key((String)"sample-sharding.threshold").intType().defaultValue((Object)1000).withDescription("The threshold of estimated shard count to trigger the sample sharding strategy. When the distribution factor is outside the upper and lower bounds, and if the estimated shard count (approximateRowCnt/chunkSize) exceeds this threshold, the sample sharding strategy will be used. This strategy can help to handle large datasets more efficiently. The default value is 1000 shards.");
    public static final Option<Integer> INVERSE_SAMPLING_RATE = Options.key((String)"inverse-sampling.rate").intType().defaultValue((Object)1000).withDescription("The inverse of the sampling rate for the sample sharding strategy. The value represents the denominator of the sampling rate fraction. For example, a value of 1000 means a sampling rate of 1/1000. This parameter is used when the sample sharding strategy is triggered.");
}

