/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffset;

public class MySqlConnectionUtils {
    public static MySqlConnection createMySqlConnection(Configuration dbzConfiguration) {
        return new MySqlConnection(new MySqlConnection.MySqlConnectionConfiguration(dbzConfiguration));
    }

    public static BinaryLogClient createBinaryClient(Configuration dbzConfiguration) {
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(dbzConfiguration);
        return new BinaryLogClient(connectorConfig.hostname(), connectorConfig.port(), connectorConfig.username(), connectorConfig.password());
    }

    public static MySqlDatabaseSchema createMySqlDatabaseSchema(MySqlConnectorConfig dbzMySqlConfig, boolean isTableIdCaseSensitive) {
        TopicSelector<TableId> topicSelector = MySqlTopicSelector.defaultSelector(dbzMySqlConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        MySqlValueConverters valueConverters = MySqlConnectionUtils.getValueConverters(dbzMySqlConfig);
        return new MySqlDatabaseSchema(dbzMySqlConfig, valueConverters, topicSelector, schemaNameAdjuster, isTableIdCaseSensitive);
    }

    public static BinlogOffset earliestBinlogOffset(JdbcConnection jdbc) {
        String showMasterStmt = "SHOW MASTER LOGS";
        JdbcConnection.ResultSetMapper<BinlogOffset> getCurrentBinlogOffset = rs -> {
            String binlogFilename = rs.getString(1);
            long binlogPosition = 4L;
            return new BinlogOffset(binlogFilename, 4L, 0L, 0L, 0L, null, null);
        };
        return MySqlConnectionUtils.getBinlogOffset(jdbc, "SHOW MASTER LOGS", getCurrentBinlogOffset);
    }

    public static BinlogOffset currentBinlogOffset(JdbcConnection jdbc) {
        String showMasterStmt = "SHOW MASTER STATUS";
        JdbcConnection.ResultSetMapper<BinlogOffset> getCurrentBinlogOffset = rs -> {
            String binlogFilename = rs.getString(1);
            long binlogPosition = rs.getLong(2);
            String gtidSet = rs.getMetaData().getColumnCount() > 4 ? rs.getString(5) : null;
            return new BinlogOffset(binlogFilename, binlogPosition, 0L, 0L, 0L, gtidSet, null);
        };
        return MySqlConnectionUtils.getBinlogOffset(jdbc, "SHOW MASTER STATUS", getCurrentBinlogOffset);
    }

    private static BinlogOffset getBinlogOffset(JdbcConnection jdbc, String showMasterStmt, JdbcConnection.ResultSetMapper<BinlogOffset> function) {
        try {
            return jdbc.queryAndMap(showMasterStmt, rs -> {
                if (rs.next()) {
                    return (BinlogOffset)function.apply(rs);
                }
                throw new SeaTunnelException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured");
            });
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured", (Throwable)e);
        }
    }

    private static MySqlValueConverters getValueConverters(MySqlConnectorConfig dbzMySqlConfig) {
        TemporalPrecisionMode timePrecisionMode = dbzMySqlConfig.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = dbzMySqlConfig.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = dbzMySqlConfig.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        boolean timeAdjusterEnabled = dbzMySqlConfig.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode, dbzMySqlConfig.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, MySqlValueConverters::defaultParsingErrorHandler);
    }

    public static boolean isTableIdCaseSensitive(JdbcConnection connection) {
        return !"0".equals(MySqlConnectionUtils.readMySqlSystemVariables(connection).get("lower_case_table_names"));
    }

    public static Map<String, String> readMySqlSystemVariables(JdbcConnection connection) {
        return MySqlConnectionUtils.querySystemVariables(connection, "SHOW VARIABLES");
    }

    private static Map<String, String> querySystemVariables(JdbcConnection connection, String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            connection.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                }
            });
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }
}

