/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql.PostgresCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql.PostgresDataTypeConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(PostgresCatalog.class);
    private static final String SELECT_COLUMNS_SQL = "SELECT \n    a.attname AS column_name, \n\t\tt.typname as type_name,\n    CASE \n        WHEN t.typname = 'varchar' THEN t.typname || '(' || (a.atttypmod - 4) || ')'\n        WHEN t.typname = 'bpchar' THEN 'char' || '(' || (a.atttypmod - 4) || ')'\n        WHEN t.typname = 'numeric' OR t.typname = 'decimal' THEN t.typname || '(' || ((a.atttypmod - 4) >> 16) || ', ' || ((a.atttypmod - 4) & 65535) || ')'\n        WHEN t.typname = 'bit' OR t.typname = 'bit varying' THEN t.typname || '(' || (a.atttypmod - 4) || ')'\n        ELSE t.typname\n    END AS full_type_name,\n    CASE\n        WHEN t.typname IN ('varchar', 'bpchar', 'bit', 'bit varying') THEN a.atttypmod - 4\n        WHEN t.typname IN ('numeric', 'decimal') THEN (a.atttypmod - 4) >> 16\n        ELSE NULL\n    END AS column_length,\n\t\tCASE\n        WHEN t.typname IN ('numeric', 'decimal') THEN (a.atttypmod - 4) & 65535\n        ELSE NULL\n    END AS column_scale,\n\t\td.description AS column_comment,\n\t\tpg_get_expr(ad.adbin, ad.adrelid) AS default_value,\n\t\tCASE WHEN a.attnotnull THEN 'NO' ELSE 'YES' END AS is_nullable\nFROM \n    pg_class c\n    JOIN pg_namespace n ON c.relnamespace = n.oid\n    JOIN pg_attribute a ON a.attrelid = c.oid\n    JOIN pg_type t ON a.atttypid = t.oid\n    LEFT JOIN pg_description d ON c.oid = d.objoid AND a.attnum = d.objsubid\n    LEFT JOIN pg_attrdef ad ON a.attnum = ad.adnum AND a.attrelid = ad.adrelid\nWHERE \n    n.nspname = '%s'\n    AND c.relname = '%s'\n    AND a.attnum > 0\nORDER BY \n    a.attnum;";
    protected static final Set<String> SYS_DATABASES = new HashSet<String>(9);
    protected final Map<String, Connection> connectionMap = new ConcurrentHashMap<String, Connection>();

    public PostgresCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        super(catalogName, username, pwd, urlInfo, defaultSchema);
    }

    public Connection getConnection(String url) {
        if (this.connectionMap.containsKey(url)) {
            return this.connectionMap.get(url);
        }
        try {
            Connection connection = DriverManager.getConnection(url, this.username, this.pwd);
            this.connectionMap.put(url, connection);
            return connection;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", url), (Throwable)e);
        }
    }

    @Override
    public void close() throws CatalogException {
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                throw new CatalogException(String.format("Failed to close %s via JDBC.", entry.getKey()), (Throwable)e);
            }
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        try (PreparedStatement ps = this.defaultConnection.prepareStatement("select datname from pg_database;");){
            ArrayList<String> databases = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String databaseName = rs.getString(1);
                if (SYS_DATABASES.contains(databaseName)) continue;
                databases.add(rs.getString(1));
            }
            ArrayList<String> arrayList = databases;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        String dbUrl = this.getUrlFromDatabaseName(databaseName);
        Connection connection = this.getConnection(dbUrl);
        try (PreparedStatement ps = connection.prepareStatement("SELECT table_schema, table_name FROM information_schema.tables;");){
            ResultSet rs = ps.executeQuery();
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                String schemaName = rs.getString("table_schema");
                String tableName = rs.getString("table_name");
                if (!StringUtils.isNotBlank(schemaName) || SYS_DATABASES.contains(schemaName)) continue;
                tables.add(schemaName + "." + tableName);
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildColumn(ResultSet resultSet, TableSchema.Builder builder) throws SQLException {
        String columnName = resultSet.getString("column_name");
        String typeName = resultSet.getString("type_name");
        String fullTypeName = resultSet.getString("full_type_name");
        long columnLength = resultSet.getLong("column_length");
        long columnScale = resultSet.getLong("column_scale");
        String columnComment = resultSet.getString("column_comment");
        Object defaultValue = resultSet.getObject("default_value");
        boolean isNullable = resultSet.getString("is_nullable").equals("YES");
        if (defaultValue != null && defaultValue.toString().contains("regclass")) {
            defaultValue = null;
        }
        SeaTunnelDataType<?> type = this.fromJdbcType(typeName, columnLength, columnScale);
        long bitLen = 0L;
        switch (typeName) {
            case "bytea": {
                bitLen = -1L;
                break;
            }
            case "text": {
                columnLength = -1L;
                break;
            }
            case "interval": {
                columnLength = 50L;
                break;
            }
            case "geometry": 
            case "geography": {
                columnLength = 255L;
                break;
            }
            case "bit": {
                bitLen = columnLength;
                break;
            }
        }
        PhysicalColumn physicalColumn = PhysicalColumn.of((String)columnName, type, (Integer)0, (boolean)isNullable, (Object)defaultValue, (String)columnComment, (String)fullTypeName, (boolean)false, (boolean)false, (Long)bitLen, null, (Long)columnLength);
        builder.column((Column)physicalColumn);
    }

    @Override
    protected boolean createTableInternal(TablePath tablePath, CatalogTable table) throws CatalogException {
        String createTableSql = new PostgresCreateTableSqlBuilder(table).build(tablePath);
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        Connection conn = this.getConnection(dbUrl);
        log.info("create table sql: {}", (Object)createTableSql);
        try (PreparedStatement ps = conn.prepareStatement(createTableSql);){
            ps.execute();
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating table %s", tablePath.getFullName()), (Throwable)e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean dropTableInternal(TablePath tablePath) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        String schemaName = tablePath.getSchemaName();
        String tableName = tablePath.getTableName();
        String sql = "DROP TABLE IF EXISTS \"" + schemaName + "\".\"" + tableName + "\"";
        Connection connection = this.getConnection(dbUrl);
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            boolean bl = ps.execute();
            return bl;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed dropping table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean createDatabaseInternal(String databaseName) throws CatalogException {
        String sql = "CREATE DATABASE \"" + databaseName + "\"";
        try (PreparedStatement ps = this.defaultConnection.prepareStatement(sql);){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    @Override
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(tablePath.getSchemaAndTableName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean dropDatabaseInternal(String databaseName) throws CatalogException {
        String sql = "DROP DATABASE IF EXISTS \"" + databaseName + "\"";
        try (PreparedStatement ps = this.defaultConnection.prepareStatement(sql);){
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed dropping database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnTypeName = metadata.getColumnTypeName(colIndex);
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", metadata.getPrecision(colIndex));
        dataTypeProperties.put("scale", metadata.getScale(colIndex));
        return new PostgresDataTypeConvertor().toSeaTunnelType(columnTypeName, dataTypeProperties);
    }

    private SeaTunnelDataType<?> fromJdbcType(String typeName, long precision, long scale) {
        HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
        dataTypeProperties.put("precision", precision);
        dataTypeProperties.put("scale", scale);
        return new PostgresDataTypeConvertor().toSeaTunnelType(typeName, dataTypeProperties);
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "jdbc");
        options.put("url", this.baseUrl + tablePath.getDatabaseName());
        options.put("table-name", tablePath.getFullName());
        options.put("username", this.username);
        options.put("password", this.pwd);
        return options;
    }

    private String getUrlFromDatabaseName(String databaseName) {
        String url = this.baseUrl.endsWith("/") ? this.baseUrl : this.baseUrl + "/";
        return url + databaseName + this.suffix;
    }

    static {
        SYS_DATABASES.add("information_schema");
        SYS_DATABASES.add("pg_catalog");
        SYS_DATABASES.add("root");
        SYS_DATABASES.add("pg_toast");
        SYS_DATABASES.add("pg_temp_1");
        SYS_DATABASES.add("pg_toast_temp_1");
        SYS_DATABASES.add("postgres");
        SYS_DATABASES.add("template0");
        SYS_DATABASES.add("template1");
    }
}

