/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertException;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataTypeConvertor.class})
public class PostgresDataTypeConvertor
implements DataTypeConvertor<String> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDialectTypeMapper.class);
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 38;
    public static final Integer DEFAULT_SCALE = 18;
    public static final String PG_SMALLSERIAL = "smallserial";
    public static final String PG_SERIAL = "serial";
    public static final String PG_BIGSERIAL = "bigserial";
    public static final String PG_BYTEA = "bytea";
    public static final String PG_BIT = "bit";
    public static final String PG_BYTEA_ARRAY = "_bytea";
    public static final String PG_SMALLINT = "int2";
    public static final String PG_SMALLINT_ARRAY = "_int2";
    public static final String PG_INTEGER = "int4";
    public static final String PG_INTEGER_ARRAY = "_int4";
    public static final String PG_BIGINT = "int8";
    public static final String PG_BIGINT_ARRAY = "_int8";
    public static final String PG_REAL = "float4";
    public static final String PG_REAL_ARRAY = "_float4";
    public static final String PG_DOUBLE_PRECISION = "float8";
    public static final String PG_DOUBLE_PRECISION_ARRAY = "_float8";
    public static final String PG_NUMERIC = "numeric";
    public static final String PG_NUMERIC_ARRAY = "_numeric";
    public static final String PG_BOOLEAN = "bool";
    public static final String PG_BOOLEAN_ARRAY = "_bool";
    public static final String PG_TIMESTAMP = "timestamp";
    public static final String PG_TIMESTAMP_ARRAY = "_timestamp";
    public static final String PG_TIMESTAMPTZ = "timestamptz";
    public static final String PG_TIMESTAMPTZ_ARRAY = "_timestamptz";
    public static final String PG_DATE = "date";
    public static final String PG_DATE_ARRAY = "_date";
    public static final String PG_TIME = "time";
    public static final String PG_TIME_ARRAY = "_time";
    public static final String PG_TEXT = "text";
    public static final String PG_TEXT_ARRAY = "_text";
    public static final String PG_CHAR = "bpchar";
    public static final String PG_CHAR_ARRAY = "_bpchar";
    public static final String PG_CHARACTER = "character";
    public static final String PG_CHARACTER_ARRAY = "_character";
    public static final String PG_CHARACTER_VARYING = "varchar";
    public static final String PG_CHARACTER_VARYING_ARRAY = "_varchar";
    public static final String PG_INTERVAL = "interval";
    public static final String PG_GEOMETRY = "geometry";
    public static final String PG_GEOGRAPHY = "geography";
    public static final String PG_JSON = "json";
    public static final String PG_JSONB = "jsonb";

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType) {
        return this.toSeaTunnelType(connectorDataType, new HashMap<String, Object>(0));
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull(connectorDataType, "Postgres Type cannot be null");
        switch (connectorDataType) {
            case "bool": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "_bool": {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case "bytea": 
            case "bit": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "_bytea": {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            case "int2": 
            case "smallserial": 
            case "int4": 
            case "serial": {
                return BasicType.INT_TYPE;
            }
            case "_int2": 
            case "_int4": {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case "int8": 
            case "bigserial": {
                return BasicType.LONG_TYPE;
            }
            case "_int8": {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            case "float4": {
                return BasicType.FLOAT_TYPE;
            }
            case "_float4": {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            case "float8": {
                return BasicType.DOUBLE_TYPE;
            }
            case "_float8": {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
            case "numeric": {
                int precision = MapUtils.getInteger(dataTypeProperties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                int scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                return new DecimalType(precision, scale);
            }
            case "bpchar": 
            case "character": 
            case "varchar": 
            case "text": 
            case "interval": 
            case "geometry": 
            case "geography": 
            case "json": 
            case "jsonb": {
                return BasicType.STRING_TYPE;
            }
            case "_bpchar": 
            case "_character": 
            case "_varchar": 
            case "_text": {
                return ArrayType.STRING_ARRAY_TYPE;
            }
            case "timestamp": 
            case "timestamptz": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "time": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "date": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support POSTGRES type '%s''  yet.", connectorDataType));
    }

    public String toConnectorType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull(seaTunnelDataType, "seaTunnelDataType cannot be null");
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case TINYINT: 
            case SMALLINT: {
                return PG_SMALLINT;
            }
            case INT: {
                return PG_INTEGER;
            }
            case BIGINT: {
                return PG_BIGINT;
            }
            case DECIMAL: {
                return PG_NUMERIC;
            }
            case FLOAT: {
                return PG_REAL;
            }
            case DOUBLE: {
                return PG_DOUBLE_PRECISION;
            }
            case BOOLEAN: {
                return PG_BOOLEAN;
            }
            case STRING: {
                return PG_TEXT;
            }
            case DATE: {
                return PG_DATE;
            }
            case BYTES: {
                return PG_BYTEA;
            }
            case TIME: {
                return PG_TIME;
            }
            case TIMESTAMP: {
                return PG_TIMESTAMP;
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support SeaTunnel type '%s''  yet.", seaTunnelDataType));
    }

    public String getIdentity() {
        return "POSTGRES";
    }
}

