/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.connector.mysql.legacy.BlockingReader;
import io.debezium.util.Clock;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedBlockingReader
extends BlockingReader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Duration timeout;
    private volatile Threads.Timer timer;

    public TimedBlockingReader(String name, Duration timeout) {
        super(name, "The connector will wait for " + timeout.toMillis() + " ms before proceeding");
        this.timeout = timeout;
    }

    @Override
    public void start() {
        super.start();
        this.timer = Threads.timer(Clock.SYSTEM, this.timeout);
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        super.poll();
        if (this.timer != null && this.timer.expired()) {
            this.stop();
        }
        return null;
    }
}

