/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.api.table.type.MultipleRowType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.SourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.MySqlIncrementalSource;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.MySqlSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;

@AutoService(value={Factory.class})
public class MySqlIncrementalSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "MySQL-CDC";
    }

    public OptionRule optionRule() {
        return JdbcSourceOptions.getBaseRule().required(new Option[]{JdbcSourceOptions.USERNAME, JdbcSourceOptions.PASSWORD, CatalogOptions.TABLE_NAMES, JdbcCatalogOptions.BASE_URL}).optional(new Option[]{JdbcSourceOptions.DATABASE_NAMES, JdbcSourceOptions.SERVER_ID, JdbcSourceOptions.SERVER_TIME_ZONE, JdbcSourceOptions.CONNECT_TIMEOUT_MS, JdbcSourceOptions.CONNECT_MAX_RETRIES, JdbcSourceOptions.CONNECTION_POOL_SIZE, JdbcSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND, JdbcSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND, JdbcSourceOptions.SAMPLE_SHARDING_THRESHOLD, JdbcSourceOptions.INVERSE_SAMPLING_RATE, JdbcSourceOptions.TABLE_NAMES_CONFIG}).optional(new Option[]{MySqlSourceOptions.STARTUP_MODE, MySqlSourceOptions.STOP_MODE}).conditional(MySqlSourceOptions.STARTUP_MODE, (Object)StartupMode.INITIAL, new Option[]{SourceOptions.EXACTLY_ONCE}).conditional(MySqlSourceOptions.STARTUP_MODE, (Object)StartupMode.SPECIFIC, new Option[]{SourceOptions.STARTUP_SPECIFIC_OFFSET_FILE, SourceOptions.STARTUP_SPECIFIC_OFFSET_POS}).conditional(MySqlSourceOptions.STOP_MODE, (Object)StopMode.SPECIFIC, new Option[]{SourceOptions.STOP_SPECIFIC_OFFSET_FILE, SourceOptions.STOP_SPECIFIC_OFFSET_POS}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return MySqlIncrementalSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> {
            List<CatalogTable> catalogTables = CatalogTableUtil.getCatalogTables((ReadonlyConfig)context.getOptions(), (ClassLoader)context.getClassLoader());
            Optional tableConfigs = context.getOptions().getOptional(JdbcSourceOptions.TABLE_NAMES_CONFIG);
            if (tableConfigs.isPresent()) {
                catalogTables = CatalogTableUtils.mergeCatalogTableConfig(catalogTables, (List)tableConfigs.get(), text -> TablePath.of((String)text, (boolean)false));
            }
            MultipleRowType dataType = CatalogTableUtil.convertToMultipleRowType((List)catalogTables);
            return new MySqlIncrementalSource(context.getOptions(), (SeaTunnelDataType<SeaTunnelRow>)dataType, catalogTables);
        };
    }
}

