/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlConnectionUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlUtils;

public class MySqlSchema {
    private static final String SHOW_CREATE_TABLE = "SHOW CREATE TABLE ";
    private static final String DESC_TABLE = "DESC ";
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlDatabaseSchema databaseSchema;
    private final Map<TableId, TableChanges.TableChange> schemasByTableId;
    private final Map<TableId, CatalogTable> tableMap;

    public MySqlSchema(MySqlSourceConfig sourceConfig, boolean isTableIdCaseSensitive, Map<TableId, CatalogTable> tableMap) {
        this.connectorConfig = sourceConfig.getDbzConnectorConfig();
        this.databaseSchema = MySqlConnectionUtils.createMySqlDatabaseSchema(this.connectorConfig, isTableIdCaseSensitive);
        this.schemasByTableId = new HashMap<TableId, TableChanges.TableChange>();
        this.tableMap = tableMap;
    }

    public TableChanges.TableChange getTableSchema(JdbcConnection jdbc, TableId tableId) {
        TableChanges.TableChange schema = this.schemasByTableId.get(tableId);
        if (schema == null) {
            schema = this.readTableSchema(jdbc, tableId);
            this.schemasByTableId.put(tableId, schema);
        }
        return schema;
    }

    private TableChanges.TableChange readTableSchema(JdbcConnection jdbc, TableId tableId) {
        HashMap tableChangeMap = new HashMap();
        String sql = SHOW_CREATE_TABLE + MySqlUtils.quote(tableId);
        try {
            jdbc.query(sql, rs -> {
                if (rs.next()) {
                    String ddl = rs.getString(2);
                    MySqlOffsetContext offsetContext = MySqlOffsetContext.initial(this.connectorConfig);
                    List<SchemaChangeEvent> schemaChangeEvents = this.databaseSchema.parseSnapshotDdl(ddl, tableId.catalog(), offsetContext, Instant.now());
                    for (SchemaChangeEvent schemaChangeEvent : schemaChangeEvents) {
                        for (TableChanges.TableChange tableChange : schemaChangeEvent.getTableChanges()) {
                            Table table = CatalogTableUtils.mergeCatalogTableConfig(tableChange.getTable(), this.tableMap.get(tableId));
                            TableChanges.TableChange newTableChange = new TableChanges.TableChange(TableChanges.TableChangeType.CREATE, table);
                            tableChangeMap.put(tableId, newTableChange);
                        }
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to read schema for table %s by running %s", tableId, sql), e);
        }
        if (!tableChangeMap.containsKey(tableId)) {
            throw new RuntimeException(String.format("Can't obtain schema for table %s by running %s", tableId, sql));
        }
        return (TableChanges.TableChange)tableChangeMap.get(tableId);
    }
}

