/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase.OceanBaseMySqlCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase.OceanBaseOracleCatalog;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

@AutoService(value={Factory.class})
public class OceanBaseCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "OceanBase";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCatalogOptions.BASE_URL);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank(urlWithDatabase), (Object)"Miss config <base-url>! Please check your config.");
        JdbcUrlUtil.UrlInfo urlInfo = JdbcUrlUtil.getUrlInfo((String)urlWithDatabase);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCatalogOptions.BASE_URL);
        }
        String compatibleMode = (String)options.get(JdbcCatalogOptions.COMPATIBLE_MODE);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank(compatibleMode), (Object)"Miss config <compatibleMode>! Please check your config.");
        if ("oracle".equalsIgnoreCase(compatibleMode.trim())) {
            return new OceanBaseOracleCatalog(catalogName, (String)options.get(JdbcCatalogOptions.USERNAME), (String)options.get(JdbcCatalogOptions.PASSWORD), urlInfo, (String)options.get(JdbcCatalogOptions.SCHEMA));
        }
        return new OceanBaseMySqlCatalog(catalogName, (String)options.get(JdbcCatalogOptions.USERNAME), (String)options.get(JdbcCatalogOptions.PASSWORD), urlInfo);
    }

    public OptionRule optionRule() {
        return JdbcCatalogOptions.BASE_RULE.required(new Option[]{JdbcCatalogOptions.COMPATIBLE_MODE}).build();
    }
}

