/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.psql.PostgresDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;

public class PostgresCreateTableSqlBuilder {
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private PostgresDataTypeConvertor postgresDataTypeConvertor;
    private String sourceCatalogName;
    private String fieldIde;
    private List<ConstraintKey> constraintKeys;
    public Boolean isHaveConstraintKey = false;
    public List<String> createIndexSqls = new ArrayList<String>();

    public PostgresCreateTableSqlBuilder(CatalogTable catalogTable) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.postgresDataTypeConvertor = new PostgresDataTypeConvertor();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.fieldIde = (String)catalogTable.getOptions().get("fieldIde");
        this.constraintKeys = catalogTable.getTableSchema().getConstraintKeys();
    }

    public String build(TablePath tablePath) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append(CatalogUtils.quoteIdentifier("CREATE TABLE ", this.fieldIde)).append(tablePath.getSchemaAndTableName("\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.quoteIdentifier(this.buildColumnSql((Column)column), this.fieldIde)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (StringUtils.isBlank(constraintKey.getConstraintName()) || this.primaryKey != null && StringUtils.equals(this.primaryKey.getPrimaryKey(), constraintKey.getConstraintName())) continue;
                this.isHaveConstraintKey = true;
                switch (constraintKey.getConstraintType()) {
                    case UNIQUE_KEY: {
                        String uniqueKeySql = this.buildUniqueKeySql(constraintKey);
                        columnSqls.add("\t" + uniqueKeySql);
                        break;
                    }
                    case INDEX_KEY: {
                        String indexKeySql = this.buildIndexKeySql(tablePath, constraintKey);
                        this.createIndexSqls.add(indexKeySql);
                        break;
                    }
                }
            }
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n);");
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank(column.getComment())).map(columns -> this.buildColumnCommentSql((Column)columns, tablePath.getSchemaAndTableName("\""))).collect(Collectors.toList());
        if (!commentSqls.isEmpty()) {
            createTableSql.append("\n");
            createTableSql.append(String.join((CharSequence)";\n", commentSqls)).append(";");
        }
        return createTableSql.toString();
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = StringUtils.equalsIgnoreCase("Postgres", this.sourceCatalogName) ? column.getSourceType() : this.buildColumnType(column);
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        if (this.primaryKey != null && this.primaryKey.getColumnNames().contains(column.getName())) {
            columnSql.append(" PRIMARY KEY");
        }
        return columnSql.toString();
    }

    private String buildColumnType(Column column) {
        SqlType sqlType = column.getDataType().getSqlType();
        Long columnLength = column.getLongColumnLength();
        switch (sqlType) {
            case BYTES: {
                return "bytea";
            }
            case STRING: {
                if (columnLength > 0L && columnLength < 0xA00000L) {
                    return "varchar(" + columnLength + ")";
                }
                return "text";
            }
        }
        Object type = this.postgresDataTypeConvertor.toConnectorType(column.getName(), column.getDataType(), (Map)null);
        if (((String)type).equals("numeric")) {
            DecimalType decimalType = (DecimalType)column.getDataType();
            return "numeric(" + decimalType.getPrecision() + "," + decimalType.getScale() + ")";
        }
        return type;
    }

    private String buildColumnCommentSql(Column column, String tableName) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append(CatalogUtils.quoteIdentifier("COMMENT ON COLUMN ", this.fieldIde)).append(tableName).append(".");
        columnCommentSql.append(CatalogUtils.quoteIdentifier(column.getName(), this.fieldIde, "\"")).append(CatalogUtils.quoteIdentifier(" IS '", this.fieldIde)).append(column.getComment()).append("'");
        return columnCommentSql.toString();
    }

    private String buildUniqueKeySql(ConstraintKey constraintKey) {
        String constraintName = constraintKey.getConstraintName();
        if (constraintName.length() > 25) {
            constraintName = constraintName.substring(0, 25);
        }
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        return "CONSTRAINT " + constraintName + " UNIQUE (" + indexColumns + ")";
    }

    private String buildIndexKeySql(TablePath tablePath, ConstraintKey constraintKey) {
        String constraintName = tablePath.getTableName() + "_" + constraintKey.getConstraintName();
        if (constraintName.length() > 25) {
            constraintName = constraintName.substring(0, 25);
        }
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        return "CREATE INDEX " + constraintName + " ON " + tablePath.getSchemaAndTableName("\"") + "(" + indexColumns + ");";
    }

    public List<String> getCreateIndexSqls() {
        return this.createIndexSqls;
    }
}

