/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal;

import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.ChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInputFormat
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcInputFormat.class);
    private final JdbcDialect jdbcDialect;
    private final JdbcRowConverter jdbcRowConverter;
    private final Map<TablePath, CatalogTable> tables;
    private final ChunkSplitter chunkSplitter;
    private transient String splitTableId;
    private transient TableSchema splitTableSchema;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private volatile boolean hasNext;

    public JdbcInputFormat(JdbcSourceConfig config, Map<TablePath, CatalogTable> tables) {
        this.jdbcDialect = JdbcDialectLoader.load(config.getJdbcConnectionConfig().getUrl(), config.getCompatibleMode());
        this.chunkSplitter = ChunkSplitter.create(config);
        this.jdbcRowConverter = this.jdbcDialect.getRowConverter();
        this.tables = tables;
    }

    public void openInputFormat() {
    }

    public void closeInputFormat() throws IOException {
        this.close();
        if (this.chunkSplitter != null) {
            this.chunkSplitter.close();
        }
    }

    public void open(JdbcSourceSplit inputSplit) throws IOException {
        try {
            this.splitTableSchema = this.tables.get(inputSplit.getTablePath()).getTableSchema();
            this.splitTableId = inputSplit.getTablePath().toString();
            this.statement = this.chunkSplitter.generateSplitStatement(inputSplit);
            this.resultSet = this.statement.executeQuery();
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException se) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.CONNECT_DATABASE_FAILED, "open() failed." + se.getMessage(), se);
        }
    }

    public void close() throws IOException {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                LOG.info("ResultSet couldn't be closed - " + e.getMessage());
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                LOG.info("Statement couldn't be closed - " + e.getMessage());
            }
        }
    }

    public boolean reachedEnd() {
        return !this.hasNext;
    }

    public SeaTunnelRow nextRecord() {
        try {
            if (!this.hasNext) {
                return null;
            }
            SeaTunnelRow seaTunnelRow = this.jdbcRowConverter.toInternal(this.resultSet, this.splitTableSchema);
            seaTunnelRow.setTableId(this.splitTableId);
            seaTunnelRow.setRowKind(RowKind.INSERT);
            this.hasNext = this.resultSet.next();
            return seaTunnelRow;
        }
        catch (SQLException se) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "Couldn't read data - " + se.getMessage(), se);
        }
        catch (NullPointerException npe) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "Couldn't access resultSet", npe);
        }
    }
}

