/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import lombok.NonNull;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcConnectionProvider
implements JdbcConnectionProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    protected final JdbcConnectionConfig jdbcConfig;
    private transient Driver loadedDriver;
    protected transient Connection connection;

    public SimpleJdbcConnectionProvider(@NonNull JdbcConnectionConfig jdbcConfig) {
        if (jdbcConfig == null) {
            throw new NullPointerException("jdbcConfig is marked non-null but is null");
        }
        this.jdbcConfig = jdbcConfig;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isConnectionValid() throws SQLException {
        return this.connection != null && this.connection.isValid(this.jdbcConfig.getConnectionCheckTimeoutSeconds());
    }

    private static Driver loadDriver(String driverName) throws ClassNotFoundException {
        Preconditions.checkNotNull(driverName);
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverName)) continue;
            return driver;
        }
        Class<?> clazz = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        try {
            return (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.CREATE_DRIVER_FAILED, "Fail to create driver of class " + driverName, ex);
        }
    }

    protected Driver getLoadedDriver() throws SQLException, ClassNotFoundException {
        if (this.loadedDriver == null) {
            this.loadedDriver = SimpleJdbcConnectionProvider.loadDriver(this.jdbcConfig.getDriverName());
        }
        return this.loadedDriver;
    }

    @Override
    public Connection getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        if (this.isConnectionValid()) {
            return this.connection;
        }
        Driver driver = this.getLoadedDriver();
        Properties info = new Properties();
        if (this.jdbcConfig.getUsername().isPresent()) {
            info.setProperty("user", this.jdbcConfig.getUsername().get());
        }
        if (this.jdbcConfig.getPassword().isPresent()) {
            info.setProperty("password", this.jdbcConfig.getPassword().get());
        }
        info.putAll(this.jdbcConfig.getProperties());
        this.connection = driver.connect(this.jdbcConfig.getUrl(), info);
        if (this.connection == null) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.NO_SUITABLE_DRIVER, "No suitable driver found for " + this.jdbcConfig.getUrl());
        }
        this.connection.setAutoCommit(this.jdbcConfig.isAutoCommit());
        return this.connection;
    }

    @Override
    public void closeConnection() {
        try {
            if (this.isConnectionValid()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("JDBC connection close failed.", (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        this.closeConnection();
        return this.getOrEstablishConnection();
    }

    public JdbcConnectionConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

