/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public interface JdbcDialectTypeMapper
extends Serializable {
    public SeaTunnelDataType<?> mapping(ResultSetMetaData var1, int var2) throws SQLException;

    default public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        int precision;
        SeaTunnelDataType<?> seaTunnelType = this.mapping(metadata, colIndex);
        String columnName = metadata.getColumnLabel(colIndex);
        int jdbcType = metadata.getColumnType(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        int columnLength = precision = metadata.getPrecision(colIndex);
        long longColumnLength = precision;
        long bitLength = 0L;
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                bitLength = precision * 8;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                columnLength = precision * 3;
                longColumnLength = precision * 3;
                break;
            }
        }
        return PhysicalColumn.of((String)columnName, seaTunnelType, (Integer)columnLength, (isNullable != 0 ? 1 : 0) != 0, null, null, (String)nativeType, (boolean)false, (boolean)false, (Long)bitLength, Collections.emptyMap(), (Long)longColumnLength);
    }
}

