/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDialect.class);
    private static final String MYSQL_UNKNOWN = "UNKNOWN";
    private static final String MYSQL_BIT = "BIT";
    private static final String MYSQL_TINYINT = "TINYINT";
    private static final String MYSQL_TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String MYSQL_SMALLINT = "SMALLINT";
    private static final String MYSQL_SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String MYSQL_MEDIUMINT = "MEDIUMINT";
    private static final String MYSQL_MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String MYSQL_INT = "INT";
    private static final String MYSQL_INT_UNSIGNED = "INT UNSIGNED";
    private static final String MYSQL_INTEGER = "INTEGER";
    private static final String MYSQL_INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    private static final String MYSQL_BIGINT = "BIGINT";
    private static final String MYSQL_BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String MYSQL_DECIMAL = "DECIMAL";
    private static final String MYSQL_DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String MYSQL_FLOAT = "FLOAT";
    private static final String MYSQL_FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String MYSQL_DOUBLE = "DOUBLE";
    private static final String MYSQL_DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String MYSQL_CHAR = "CHAR";
    private static final String MYSQL_VARCHAR = "VARCHAR";
    private static final String MYSQL_TINYTEXT = "TINYTEXT";
    private static final String MYSQL_MEDIUMTEXT = "MEDIUMTEXT";
    private static final String MYSQL_TEXT = "TEXT";
    private static final String MYSQL_LONGTEXT = "LONGTEXT";
    private static final String MYSQL_JSON = "JSON";
    private static final String MYSQL_DATE = "DATE";
    private static final String MYSQL_DATETIME = "DATETIME";
    private static final String MYSQL_TIME = "TIME";
    private static final String MYSQL_TIMESTAMP = "TIMESTAMP";
    private static final String MYSQL_YEAR = "YEAR";
    private static final String MYSQL_TINYBLOB = "TINYBLOB";
    private static final String MYSQL_MEDIUMBLOB = "MEDIUMBLOB";
    private static final String MYSQL_BLOB = "BLOB";
    private static final String MYSQL_LONGBLOB = "LONGBLOB";
    private static final String MYSQL_BINARY = "BINARY";
    private static final String MYSQL_VARBINARY = "VARBINARY";
    private static final String MYSQL_GEOMETRY = "GEOMETRY";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String mysqlType = metadata.getColumnTypeName(colIndex).toUpperCase();
        String columnName = metadata.getColumnName(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (mysqlType) {
            case "BIT": {
                if (precision == 1) {
                    return BasicType.BOOLEAN_TYPE;
                }
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "TINYINT": 
            case "TINYINT UNSIGNED": 
            case "SMALLINT": 
            case "SMALLINT UNSIGNED": 
            case "MEDIUMINT": 
            case "MEDIUMINT UNSIGNED": 
            case "INT": 
            case "INTEGER": 
            case "YEAR": {
                return BasicType.INT_TYPE;
            }
            case "INT UNSIGNED": 
            case "INTEGER UNSIGNED": 
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "BIGINT UNSIGNED": {
                return new DecimalType(20, 0);
            }
            case "DECIMAL": {
                if (precision > 38) {
                    LOG.warn("{} will probably cause value overflow.", (Object)MYSQL_DECIMAL);
                    return new DecimalType(38, 18);
                }
                return new DecimalType(precision, scale);
            }
            case "DECIMAL UNSIGNED": {
                return new DecimalType(precision + 1, scale);
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "FLOAT UNSIGNED": {
                LOG.warn("{} will probably cause value overflow.", (Object)MYSQL_FLOAT_UNSIGNED);
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "DOUBLE UNSIGNED": {
                LOG.warn("{} will probably cause value overflow.", (Object)MYSQL_DOUBLE_UNSIGNED);
                return BasicType.DOUBLE_TYPE;
            }
            case "CHAR": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "TEXT": 
            case "VARCHAR": 
            case "JSON": {
                return BasicType.STRING_TYPE;
            }
            case "LONGTEXT": {
                LOG.warn("Type '{}' has a maximum precision of 536870911 in MySQL. Due to limitations in the seatunnel type system, the precision will be set to 2147483647.", (Object)MYSQL_LONGTEXT);
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "TINYBLOB": 
            case "MEDIUMBLOB": 
            case "BLOB": 
            case "LONGBLOB": 
            case "VARBINARY": 
            case "BINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"MySQL", (String)mysqlType, (String)jdbcColumnName);
    }
}

