/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.phoenix;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixTypeMapper.class);
    private static final String PHOENIX_UNKNOWN = "UNKNOWN";
    private static final String PHOENIX_BOOLEAN = "BOOLEAN";
    private static final String PHOENIX_ARRAY = "ARRAY";
    private static final String PHOENIX_TINYINT = "TINYINT";
    private static final String PHOENIX_UNSIGNED_TINYINT = "UNSIGNED_TINYINT";
    private static final String PHOENIX_SMALLINT = "SMALLINT";
    private static final String PHOENIX_UNSIGNED_SMALLINT = "UNSIGNED_SMALLINT";
    private static final String PHOENIX_UNSIGNED_INT = "UNSIGNED_INT";
    private static final String PHOENIX_INTEGER = "INTEGER";
    private static final String PHOENIX_BIGINT = "BIGINT";
    private static final String PHOENIX_UNSIGNED_LONG = "UNSIGNED_LONG";
    private static final String PHOENIX_DECIMAL = "DECIMAL";
    private static final String PHOENIX_FLOAT = "FLOAT";
    private static final String PHOENIX_UNSIGNED_FLOAT = "UNSIGNED_FLOAT";
    private static final String PHOENIX_DOUBLE = "DOUBLE";
    private static final String PHOENIX_UNSIGNED_DOUBLE = "UNSIGNED_DOUBLE";
    private static final String PHOENIX_CHAR = "CHAR";
    private static final String PHOENIX_VARCHAR = "VARCHAR";
    private static final String PHOENIX_DATE = "DATE";
    private static final String PHOENIX_TIME = "TIME";
    private static final String PHOENIX_TIMESTAMP = "TIMESTAMP";
    private static final String PHOENIX_DATE_UNSIGNED = "UNSIGNED_DATE";
    private static final String PHOENIX_TIME_UNSIGNED = "UNSIGNED_TIME";
    private static final String PHOENIX_TIMESTAMP_UNSIGNED = "UNSIGNED_TIMESTAMP";
    private static final String PHOENIX_BINARY = "BINARY";
    private static final String PHOENIX_VARBINARY = "VARBINARY";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String phoenixType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (phoenixType) {
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": 
            case "UNSIGNED_TINYINT": {
                return BasicType.BYTE_TYPE;
            }
            case "UNSIGNED_INT": 
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "UNSIGNED_SMALLINT": 
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "BIGINT": 
            case "UNSIGNED_LONG": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": {
                return new DecimalType(precision, scale);
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "UNSIGNED_FLOAT": {
                LOG.warn("{} will probably cause value overflow.", (Object)PHOENIX_UNSIGNED_FLOAT);
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "UNSIGNED_DOUBLE": {
                LOG.warn("{} will probably cause value overflow.", (Object)PHOENIX_UNSIGNED_DOUBLE);
                return BasicType.DOUBLE_TYPE;
            }
            case "CHAR": 
            case "VARCHAR": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": 
            case "UNSIGNED_DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": 
            case "UNSIGNED_TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "UNSIGNED_TIMESTAMP": 
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "VARBINARY": 
            case "BINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"Phoenix", (String)phoenixType, (String)jdbcColumnName);
    }
}

