/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcUtils;

public class PostgresJdbcRowConverter
extends AbstractJdbcRowConverter {
    private static final String PG_GEOMETRY = "GEOMETRY";
    private static final String PG_GEOGRAPHY = "GEOGRAPHY";

    @Override
    public String converterName() {
        return "Postgres";
    }

    @Override
    public SeaTunnelRow toInternal(ResultSet rs, TableSchema tableSchema) throws SQLException {
        SeaTunnelRowType typeInfo = tableSchema.toPhysicalRowDataType();
        Object[] fields = new Object[typeInfo.getTotalFields()];
        block16: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            int resultSetIndex = fieldIndex + 1;
            String metaDataColumnType = rs.getMetaData().getColumnTypeName(resultSetIndex).toUpperCase(Locale.ROOT);
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    if (metaDataColumnType.equals(PG_GEOMETRY) || metaDataColumnType.equals(PG_GEOGRAPHY)) {
                        fields[fieldIndex] = rs.getObject(resultSetIndex) == null ? null : rs.getObject(resultSetIndex).toString();
                        continue block16;
                    }
                    fields[fieldIndex] = JdbcUtils.getString(rs, resultSetIndex);
                    continue block16;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = JdbcUtils.getBoolean(rs, resultSetIndex);
                    continue block16;
                }
                case TINYINT: {
                    fields[fieldIndex] = JdbcUtils.getByte(rs, resultSetIndex);
                    continue block16;
                }
                case SMALLINT: {
                    fields[fieldIndex] = JdbcUtils.getShort(rs, resultSetIndex);
                    continue block16;
                }
                case INT: {
                    fields[fieldIndex] = JdbcUtils.getInt(rs, resultSetIndex);
                    continue block16;
                }
                case BIGINT: {
                    fields[fieldIndex] = JdbcUtils.getLong(rs, resultSetIndex);
                    continue block16;
                }
                case FLOAT: {
                    fields[fieldIndex] = JdbcUtils.getFloat(rs, resultSetIndex);
                    continue block16;
                }
                case DOUBLE: {
                    fields[fieldIndex] = JdbcUtils.getDouble(rs, resultSetIndex);
                    continue block16;
                }
                case DECIMAL: {
                    fields[fieldIndex] = JdbcUtils.getBigDecimal(rs, resultSetIndex);
                    continue block16;
                }
                case DATE: {
                    Date sqlDate = JdbcUtils.getDate(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlDate).map(e -> e.toLocalDate()).orElse(null);
                    continue block16;
                }
                case TIME: {
                    Time sqlTime = JdbcUtils.getTime(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTime).map(e -> e.toLocalTime()).orElse(null);
                    continue block16;
                }
                case TIMESTAMP: {
                    Timestamp sqlTimestamp = JdbcUtils.getTimestamp(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTimestamp).map(e -> e.toLocalDateTime()).orElse(null);
                    continue block16;
                }
                case BYTES: {
                    fields[fieldIndex] = JdbcUtils.getBytes(rs, resultSetIndex);
                    continue block16;
                }
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block16;
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }
}

