/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;

public class IrisDialect
implements JdbcDialect {
    private static final Integer DEFAULT_IRIS_FETCH_SIZE = 500;
    private String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public IrisDialect() {
    }

    public IrisDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "IRIS";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new IrisJdbcRowConverter();
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        throw new SeaTunnelException("The iris database is not supported hash or md5 function. Please remove the partition_column property in config.");
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new IrisTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteIdentifier(tableName);
    }

    @Override
    public String extractTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getSchemaAndTableName());
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String insertIntoStatement = this.getInsertIntoStatement(database, tableName, fieldNames);
        return Optional.of(insertIntoStatement);
    }

    @Override
    public String getInsertIntoStatement(String database, String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName).collect(Collectors.joining(", "));
        return String.format("INSERT OR UPDATE %s (%s) VALUES (%s)", this.tableIdentifier(database, tableName), columns, placeholders);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(DEFAULT_IRIS_FETCH_SIZE);
        }
        return statement;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSetMetaData getResultSetMetaData(Connection conn, String query) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(query);
        return ps.executeQuery().getMetaData();
    }
}

