/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium.row;

import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.seatunnel.format.compatible.debezium.json.CompatibleDebeziumJsonDeserializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumJsonDeserializeSchema
implements DebeziumDeserializationSchema<SeaTunnelRow> {
    private static final Logger log = LoggerFactory.getLogger(DebeziumJsonDeserializeSchema.class);
    private static final String KEY_SCHEMA_ENABLE = "key.converter.schemas.enable";
    private static final String VALUE_SCHEMA_ENABLE = "value.converter.schemas.enable";
    private final CompatibleDebeziumJsonDeserializationSchema deserializationSchema;

    public DebeziumJsonDeserializeSchema(Map<String, String> debeziumConfig) {
        boolean keySchemaEnable = Boolean.valueOf(debeziumConfig.getOrDefault(KEY_SCHEMA_ENABLE, "true"));
        boolean valueSchemaEnable = Boolean.valueOf(debeziumConfig.getOrDefault(VALUE_SCHEMA_ENABLE, "true"));
        this.deserializationSchema = new CompatibleDebeziumJsonDeserializationSchema(keySchemaEnable, valueSchemaEnable);
    }

    @Override
    public void deserialize(SourceRecord record, Collector<SeaTunnelRow> out) throws Exception {
        SeaTunnelRow row = this.deserializationSchema.deserialize(record);
        out.collect((Object)row);
    }

    @Override
    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

