/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.JdbcDataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.splitter.ChunkSplitter;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.enumerator.MySqlChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.MySqlSourceFetchTaskContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.binlog.MySqlBinlogFetchTask;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.scan.MySqlSnapshotFetchTask;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlConnectionUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlSchema;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.TableDiscoveryUtils;

public class MySqlDialect
implements JdbcDataSourceDialect {
    private static final String QUOTED_CHARACTER = "`";
    private static final long serialVersionUID = 1L;
    private final MySqlSourceConfig sourceConfig;
    private transient MySqlSchema mySqlSchema;
    private final Map<TableId, CatalogTable> tableMap;

    public MySqlDialect(MySqlSourceConfigFactory configFactory, List<CatalogTable> catalogTables) {
        this.sourceConfig = configFactory.create(0);
        this.tableMap = CatalogTableUtils.convertTables(catalogTables);
    }

    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    public boolean isDataCollectionIdCaseSensitive(JdbcSourceConfig sourceConfig) {
        boolean bl;
        block8: {
            JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);
            try {
                bl = this.isDataCollectionIdCaseSensitive(jdbcConnection);
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new SeaTunnelException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
                }
            }
            jdbcConnection.close();
        }
        return bl;
    }

    @Override
    private boolean isDataCollectionIdCaseSensitive(JdbcConnection jdbcConnection) {
        return MySqlConnectionUtils.isTableIdCaseSensitive(jdbcConnection);
    }

    @Override
    public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        return MySqlConnectionUtils.createMySqlConnection(sourceConfig.getDbzConfiguration());
    }

    @Override
    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig) {
        return new MySqlChunkSplitter(sourceConfig, this);
    }

    @Override
    public List<TableId> discoverDataCollections(JdbcSourceConfig sourceConfig) {
        List<TableId> list;
        block8: {
            MySqlSourceConfig mySqlSourceConfig = (MySqlSourceConfig)sourceConfig;
            JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);
            try {
                list = TableDiscoveryUtils.listTables(jdbcConnection, mySqlSourceConfig.getTableFilters());
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new SeaTunnelException("Error to discover tables: " + e.getMessage(), (Throwable)e);
                }
            }
            jdbcConnection.close();
        }
        return list;
    }

    @Override
    public TableChanges.TableChange queryTableSchema(JdbcConnection jdbc, TableId tableId) {
        if (this.mySqlSchema == null) {
            this.mySqlSchema = new MySqlSchema(this.sourceConfig, this.isDataCollectionIdCaseSensitive(jdbc), this.tableMap);
        }
        return this.mySqlSchema.getTableSchema(jdbc, tableId);
    }

    @Override
    public MySqlSourceFetchTaskContext createFetchTaskContext(SourceSplitBase sourceSplitBase, JdbcSourceConfig taskSourceConfig) {
        return new MySqlSourceFetchTaskContext(taskSourceConfig, this);
    }

    @Override
    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase sourceSplitBase) {
        if (sourceSplitBase.isSnapshotSplit()) {
            return new MySqlSnapshotFetchTask(sourceSplitBase.asSnapshotSplit());
        }
        return new MySqlBinlogFetchTask(sourceSplitBase.asIncrementalSplit());
    }

    @Override
    public Optional<PrimaryKey> getPrimaryKey(JdbcConnection jdbcConnection, TableId tableId) {
        return Optional.ofNullable(this.tableMap.get(tableId).getTableSchema().getPrimaryKey());
    }

    @Override
    public List<ConstraintKey> getConstraintKeys(JdbcConnection jdbcConnection, TableId tableId) {
        return this.tableMap.get(tableId).getTableSchema().getConstraintKeys();
    }
}

