/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.util.csv;

import java.io.Reader;
import org.apache.seatunnel.shade.org.postgresql.util.csv.CSVParser;
import org.apache.seatunnel.shade.org.postgresql.util.csv.CSVParserBuilder;
import org.apache.seatunnel.shade.org.postgresql.util.csv.CSVReader;
import org.apache.seatunnel.shade.org.postgresql.util.csv.CSVReaderNullFieldIndicator;

public class CSVReaderBuilder {
    private final CSVParserBuilder parserBuilder = new CSVParserBuilder();
    private final Reader reader;
    private int skipLines = 0;
    private CSVParser csvParser = null;
    private boolean keepCR;
    private boolean verifyReader = false;
    private CSVReaderNullFieldIndicator nullFieldIndicator = CSVReaderNullFieldIndicator.NEITHER;

    public CSVReaderBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        this.reader = reader;
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected int getSkipLines() {
        return this.skipLines;
    }

    protected CSVParser getCsvParser() {
        return this.csvParser;
    }

    public CSVReaderBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines <= 0 ? 0 : skipLines;
        return this;
    }

    public CSVReaderBuilder withCSVParser(CSVParser csvParser) {
        this.csvParser = csvParser;
        return this;
    }

    public CSVReader build() {
        CSVParser parser = this.csvParser != null ? this.csvParser : this.parserBuilder.withFieldAsNull(this.nullFieldIndicator).build();
        return new CSVReader(this.reader, this.skipLines, parser, this.keepCR, this.verifyReader);
    }

    public CSVReaderBuilder withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    protected boolean keepCarriageReturn() {
        return this.keepCR;
    }

    public CSVReaderBuilder withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }

    public CSVReaderBuilder withFieldAsNull(CSVReaderNullFieldIndicator indicator) {
        this.nullFieldIndicator = indicator;
        return this;
    }
}

