/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.utils;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;

public class PostgresSchema {
    private final PostgresConnectorConfig connectorConfig;
    private final Map<TableId, TableChanges.TableChange> schemasByTableId = new ConcurrentHashMap<TableId, TableChanges.TableChange>();
    private final Map<TableId, CatalogTable> tableMap;

    public PostgresSchema(PostgresConnectorConfig connectorConfig, Map<TableId, CatalogTable> tableMap) {
        this.connectorConfig = connectorConfig;
        this.tableMap = tableMap;
    }

    public TableChanges.TableChange getTableSchema(JdbcConnection jdbc, TableId tableId) {
        TableChanges.TableChange schema = this.schemasByTableId.get(tableId);
        if (schema == null) {
            schema = this.readTableSchema(jdbc, tableId);
        }
        return schema;
    }

    private TableChanges.TableChange readTableSchema(JdbcConnection jdbc, TableId tableId) {
        TableId tableIdWithoutCatalog = new TableId(null, tableId.schema(), tableId.table());
        PostgresConnection postgresConnection = (PostgresConnection)jdbc;
        Tables tables = new Tables();
        try {
            postgresConnection.readSchema(tables, tableIdWithoutCatalog.catalog(), tableIdWithoutCatalog.schema(), this.connectorConfig.getTableFilters().dataCollectionFilter(), null, false);
            for (TableId id : tables.tableIds()) {
                TableId idWithCatalog = new TableId(tableId.catalog(), id.schema(), id.table());
                if (!this.tableMap.containsKey(idWithCatalog)) continue;
                Table table = CatalogTableUtils.mergeCatalogTableConfig(tables.forTable(id), this.tableMap.get(idWithCatalog));
                TableChanges.TableChange tableChange = new TableChanges.TableChange(TableChanges.TableChangeType.CREATE, table);
                this.schemasByTableId.put(idWithCatalog, tableChange);
            }
        }
        catch (SQLException e) {
            throw new SeaTunnelException(String.format("Failed to read schema for table %s ", tableId), (Throwable)e);
        }
        if (!this.schemasByTableId.containsKey(tableId)) {
            throw new SeaTunnelException(String.format("Can't obtain schema for table %s ", tableId));
        }
        return this.schemasByTableId.get(tableId);
    }
}

