/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.replication.fluent.logical;

import java.sql.SQLException;
import java.sql.Statement;
import org.apache.seatunnel.shade.org.postgresql.core.BaseConnection;
import org.apache.seatunnel.shade.org.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import org.apache.seatunnel.shade.org.postgresql.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;

public class LogicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedLogicalCreateSlotBuilder>
implements ChainedLogicalCreateSlotBuilder {
    private String outputPlugin;
    private BaseConnection connection;

    public LogicalCreateSlotBuilder(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    protected ChainedLogicalCreateSlotBuilder self() {
        return this;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withOutputPlugin(String outputPlugin) {
        this.outputPlugin = outputPlugin;
        return this.self();
    }

    @Override
    public void make() throws SQLException {
        if (this.outputPlugin == null || this.outputPlugin.isEmpty()) {
            throw new IllegalArgumentException("OutputPlugin required parameter for logical replication slot");
        }
        if (this.slotName == null || this.slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slotName can't be null");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute(String.format("CREATE_REPLICATION_SLOT %s LOGICAL %s", this.slotName, this.outputPlugin));
        }
    }
}

