/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.util;

import java.util.ArrayList;
import java.util.List;

public class PGtokenizer {
    protected List<String> tokens;

    public PGtokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens = new ArrayList<String>();
        int nest = 0;
        boolean skipChar = false;
        boolean nestedDoubleQuote = false;
        int s2 = 0;
        for (int p = 0; p < string.length(); ++p) {
            char c = string.charAt(p);
            if (c == '(' || c == '[' || c == '<' || !nestedDoubleQuote && !skipChar && c == '\"') {
                ++nest;
                if (c == '\"') {
                    nestedDoubleQuote = true;
                    skipChar = true;
                }
            }
            if (c == ')' || c == ']' || c == '>' || nestedDoubleQuote && !skipChar && c == '\"') {
                --nest;
                if (c == '\"') {
                    nestedDoubleQuote = false;
                }
            }
            boolean bl = skipChar = c == '\\';
            if (nest != 0 || c != delim) continue;
            this.tokens.add(string.substring(s2, p));
            s2 = p + 1;
        }
        if (s2 < string.length()) {
            this.tokens.add(string.substring(s2));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return this.tokens.get(n);
    }

    public PGtokenizer tokenizeToken(int n, char delim) {
        return new PGtokenizer(this.getToken(n), delim);
    }

    public static String remove(String s2, String l, String t) {
        if (s2.startsWith(l)) {
            s2 = s2.substring(l.length());
        }
        if (s2.endsWith(t)) {
            s2 = s2.substring(0, s2.length() - t.length());
        }
        return s2;
    }

    public void remove(String l, String t) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            this.tokens.set(i, PGtokenizer.remove(this.tokens.get(i), l, t));
        }
    }

    public static String removePara(String s2) {
        return PGtokenizer.remove(s2, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s2) {
        return PGtokenizer.remove(s2, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s2) {
        return PGtokenizer.remove(s2, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }

    public static String removeCurlyBrace(String s2) {
        return PGtokenizer.remove(s2, "{", "}");
    }

    public void removeCurlyBrace() {
        this.remove("{", "}");
    }
}

