/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.key.Key;
import org.tikv.common.region.TiStore;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.replica.Region;
import org.tikv.common.replica.ReplicaSelector;
import org.tikv.common.replica.Store;
import org.tikv.common.util.FastByteComparisons;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.protobuf.ByteString;

public class TiRegion
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TiRegion.class);
    private final Metapb.Region meta;
    private final Kvrpcpb.IsolationLevel isolationLevel;
    private final Kvrpcpb.CommandPri commandPri;
    private final TiConfiguration conf;
    private final Metapb.Peer leader;
    private final ReplicaSelector replicaSelector;
    private final List<Metapb.Peer> replicaList;
    private int replicaIdx;
    private final List<Metapb.Peer> peers;
    private final List<TiStore> stores;

    public TiRegion(TiConfiguration conf, Metapb.Region meta, Metapb.Peer leader, List<Metapb.Peer> peers, List<TiStore> stores) {
        this.conf = Objects.requireNonNull(conf, "conf is null");
        this.meta = Objects.requireNonNull(meta, "meta is null");
        this.isolationLevel = conf.getIsolationLevel();
        this.commandPri = conf.getCommandPriority();
        this.peers = peers;
        this.stores = stores;
        this.replicaSelector = conf.getReplicaSelector();
        if (leader == null || leader.getId() == 0L) {
            if (meta.getPeersCount() == 0) {
                throw new TiClientInternalException("Empty peer list for region " + meta.getId());
            }
            this.leader = meta.getPeers(0);
        } else {
            this.leader = leader;
        }
        this.replicaList = this.replicaSelector.select(new Region(meta, this.leader, peers, stores)).stream().map(Store::getPeer).collect(Collectors.toList());
        this.replicaIdx = 0;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public Metapb.Peer getLeader() {
        return this.leader;
    }

    public List<Metapb.Peer> getFollowerList() {
        ArrayList<Metapb.Peer> peers = new ArrayList<Metapb.Peer>();
        for (Metapb.Peer peer : this.getMeta().getPeersList()) {
            if (peer.equals(this.leader) || !peer.getRole().equals(Metapb.PeerRole.Voter)) continue;
            peers.add(peer);
        }
        return peers;
    }

    public List<Metapb.Peer> getLearnerList() {
        ArrayList<Metapb.Peer> peers = new ArrayList<Metapb.Peer>();
        for (Metapb.Peer peer : this.getMeta().getPeersList()) {
            if (!peer.getRole().equals(Metapb.PeerRole.Learner)) continue;
            peers.add(peer);
        }
        return peers;
    }

    public List<Metapb.Peer> getPeersList() {
        return this.getMeta().getPeersList();
    }

    public Metapb.Peer getCurrentReplica() {
        return this.replicaList.get(this.replicaIdx);
    }

    public Metapb.Peer getNextReplica() {
        this.replicaIdx = (this.replicaIdx + 1) % this.replicaList.size();
        return this.getCurrentReplica();
    }

    private boolean isLeader(Metapb.Peer peer) {
        return this.getLeader().equals(peer);
    }

    public long getId() {
        return this.meta.getId();
    }

    public ByteString getStartKey() {
        return this.meta.getStartKey();
    }

    public boolean contains(Key key) {
        return KeyRangeUtils.makeRange(this.getStartKey(), this.getEndKey()).contains(key);
    }

    public ByteString getEndKey() {
        return this.meta.getEndKey();
    }

    public Kvrpcpb.Context getLeaderContext() {
        return this.getContext(this.leader, Collections.emptySet(), false);
    }

    public Kvrpcpb.Context getReplicaContext(Set<Long> resolvedLocks, TiStoreType storeType) {
        Metapb.Peer currentPeer = this.getCurrentReplica();
        boolean replicaRead = !this.isLeader(currentPeer) && TiStoreType.TiKV.equals((Object)storeType);
        return this.getContext(currentPeer, resolvedLocks, replicaRead);
    }

    public Kvrpcpb.Context getReplicaContext(Metapb.Peer currentPeer, Set<Long> resolvedLocks) {
        return this.getContext(currentPeer, resolvedLocks, false);
    }

    public Kvrpcpb.Context getReplicaContext(Metapb.Peer currentPeer) {
        return this.getContext(currentPeer, Collections.emptySet(), false);
    }

    private Kvrpcpb.Context getContext(Metapb.Peer currentPeer, Set<Long> resolvedLocks, boolean replicaRead) {
        Kvrpcpb.Context.Builder builder = Kvrpcpb.Context.newBuilder();
        builder.setIsolationLevel(this.isolationLevel).setPriority(this.commandPri).setRegionId(this.meta.getId()).setPeer(currentPeer).setReplicaRead(replicaRead).setRegionEpoch(this.meta.getRegionEpoch());
        builder.addAllResolvedLocks(resolvedLocks);
        return builder.build();
    }

    public RegionVerID getVerID() {
        return new RegionVerID(this.meta.getId(), this.meta.getRegionEpoch().getConfVer(), this.meta.getRegionEpoch().getVersion());
    }

    public TiRegion switchPeer(long leaderStoreID) {
        List<Metapb.Peer> peers = this.meta.getPeersList();
        for (Metapb.Peer p : peers) {
            if (p.getStoreId() != leaderStoreID) continue;
            return new TiRegion(this.conf, this.meta, p, peers, this.stores);
        }
        return null;
    }

    public boolean isMoreThan(ByteString key) {
        return FastByteComparisons.compareTo(this.meta.getStartKey().toByteArray(), 0, this.meta.getStartKey().size(), key.toByteArray(), 0, key.size()) > 0;
    }

    public boolean isLessThan(ByteString key) {
        return FastByteComparisons.compareTo(this.meta.getEndKey().toByteArray(), 0, this.meta.getEndKey().size(), key.toByteArray(), 0, key.size()) <= 0;
    }

    public boolean contains(ByteString key) {
        return !this.isMoreThan(key) && !this.isLessThan(key);
    }

    public boolean isValid() {
        return this.leader != null && this.meta != null;
    }

    public Metapb.RegionEpoch getRegionEpoch() {
        return this.meta.getRegionEpoch();
    }

    public Metapb.Region getMeta() {
        return this.meta;
    }

    public boolean equals(Object another) {
        if (!(another instanceof TiRegion)) {
            return false;
        }
        TiRegion anotherRegion = (TiRegion)another;
        return anotherRegion.meta.equals(this.meta) && anotherRegion.leader.equals(this.leader) && anotherRegion.commandPri.equals(this.commandPri) && anotherRegion.isolationLevel.equals(this.isolationLevel);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.leader, this.isolationLevel, this.commandPri);
    }

    public String toString() {
        return String.format("{Region[%d] ConfVer[%d] Version[%d] Store[%d] KeyRange[%s]:[%s]}", this.getId(), this.getRegionEpoch().getConfVer(), this.getRegionEpoch().getVersion(), this.getLeader().getStoreId(), KeyUtils.formatBytesUTF8(this.getStartKey()), KeyUtils.formatBytesUTF8(this.getEndKey()));
    }

    public class RegionVerID {
        final long id;
        final long confVer;
        final long ver;

        RegionVerID(long id, long confVer, long ver) {
            this.id = id;
            this.confVer = confVer;
            this.ver = ver;
        }

        public long getId() {
            return this.id;
        }

        public long getConfVer() {
            return this.confVer;
        }

        public long getVer() {
            return this.ver;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegionVerID)) {
                return false;
            }
            RegionVerID that = (RegionVerID)other;
            return this.id == that.id && this.confVer == that.confVer && this.ver == that.ver;
        }

        public int hashCode() {
            int hash = Long.hashCode(this.id);
            hash = hash * 31 + Long.hashCode(this.confVer);
            hash = hash * 31 + Long.hashCode(this.ver);
            return hash;
        }
    }
}

