/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceOptions;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JdbcSourceTableConfig
implements Serializable {
    private static final int DEFAULT_PARTITION_NUMBER = 10;
    @JsonProperty(value="table_path")
    private String tablePath;
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="partition_column")
    private String partitionColumn;
    @JsonProperty(value="partition_num")
    private Integer partitionNumber;
    @JsonProperty(value="partition_lower_bound")
    private String partitionStart;
    @JsonProperty(value="partition_upper_bound")
    private String partitionEnd;
    @JsonProperty(value="use_select_count")
    private Boolean useSelectCount;
    @JsonProperty(value="skip_analyze")
    private Boolean skipAnalyze;

    public JdbcSourceTableConfig() {
    }

    public static List<JdbcSourceTableConfig> of(ReadonlyConfig connectorConfig) {
        List tableIds;
        HashSet tableIdSet;
        List<JdbcSourceTableConfig> tableList;
        if (connectorConfig.getOptional(JdbcSourceOptions.TABLE_LIST).isPresent()) {
            if (connectorConfig.getOptional(JdbcOptions.QUERY).isPresent() || connectorConfig.getOptional(JdbcSourceOptions.TABLE_PATH).isPresent()) {
                throw new IllegalArgumentException("Please configure either `table_list` or `table_path`/`query`, not both");
            }
            tableList = (List<JdbcSourceTableConfig>)connectorConfig.get(JdbcSourceOptions.TABLE_LIST);
        } else {
            JdbcSourceTableConfig tableProperty = JdbcSourceTableConfig.builder().tablePath((String)connectorConfig.get(JdbcSourceOptions.TABLE_PATH)).query((String)connectorConfig.get(JdbcOptions.QUERY)).partitionColumn((String)connectorConfig.get(JdbcOptions.PARTITION_COLUMN)).partitionNumber((Integer)connectorConfig.get(JdbcOptions.PARTITION_NUM)).partitionStart((String)connectorConfig.get(JdbcOptions.PARTITION_LOWER_BOUND)).partitionEnd((String)connectorConfig.get(JdbcOptions.PARTITION_UPPER_BOUND)).build();
            tableList = Collections.singletonList(tableProperty);
        }
        tableList.forEach(tableConfig -> {
            if (tableConfig.getPartitionNumber() == null) {
                tableConfig.setPartitionNumber(10);
            }
            tableConfig.setUseSelectCount((Boolean)connectorConfig.get(JdbcSourceOptions.USE_SELECT_COUNT));
            tableConfig.setSkipAnalyze((Boolean)connectorConfig.get(JdbcSourceOptions.SKIP_ANALYZE));
        });
        if (tableList.size() > 1 && (tableIdSet = new HashSet(tableIds = tableList.stream().map(JdbcSourceTableConfig::getTablePath).collect(Collectors.toList()))).size() < tableList.size() - 1) {
            throw new IllegalArgumentException("Please configure unique `table_path`, not allow null/duplicate table path: " + tableIds);
        }
        return tableList;
    }

    JdbcSourceTableConfig(String tablePath, String query, String partitionColumn, Integer partitionNumber, String partitionStart, String partitionEnd, Boolean useSelectCount, Boolean skipAnalyze) {
        this.tablePath = tablePath;
        this.query = query;
        this.partitionColumn = partitionColumn;
        this.partitionNumber = partitionNumber;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.useSelectCount = useSelectCount;
        this.skipAnalyze = skipAnalyze;
    }

    public static JdbcSourceTableConfigBuilder builder() {
        return new JdbcSourceTableConfigBuilder();
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    public Integer getPartitionNumber() {
        return this.partitionNumber;
    }

    public String getPartitionStart() {
        return this.partitionStart;
    }

    public String getPartitionEnd() {
        return this.partitionEnd;
    }

    public Boolean getUseSelectCount() {
        return this.useSelectCount;
    }

    public Boolean getSkipAnalyze() {
        return this.skipAnalyze;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPartitionColumn(String partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public void setPartitionNumber(Integer partitionNumber) {
        this.partitionNumber = partitionNumber;
    }

    public void setPartitionStart(String partitionStart) {
        this.partitionStart = partitionStart;
    }

    public void setPartitionEnd(String partitionEnd) {
        this.partitionEnd = partitionEnd;
    }

    public void setUseSelectCount(Boolean useSelectCount) {
        this.useSelectCount = useSelectCount;
    }

    public void setSkipAnalyze(Boolean skipAnalyze) {
        this.skipAnalyze = skipAnalyze;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSourceTableConfig)) {
            return false;
        }
        JdbcSourceTableConfig other = (JdbcSourceTableConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$partitionNumber = this.getPartitionNumber();
        Integer other$partitionNumber = other.getPartitionNumber();
        if (this$partitionNumber == null ? other$partitionNumber != null : !((Object)this$partitionNumber).equals(other$partitionNumber)) {
            return false;
        }
        Boolean this$useSelectCount = this.getUseSelectCount();
        Boolean other$useSelectCount = other.getUseSelectCount();
        if (this$useSelectCount == null ? other$useSelectCount != null : !((Object)this$useSelectCount).equals(other$useSelectCount)) {
            return false;
        }
        Boolean this$skipAnalyze = this.getSkipAnalyze();
        Boolean other$skipAnalyze = other.getSkipAnalyze();
        if (this$skipAnalyze == null ? other$skipAnalyze != null : !((Object)this$skipAnalyze).equals(other$skipAnalyze)) {
            return false;
        }
        String this$tablePath = this.getTablePath();
        String other$tablePath = other.getTablePath();
        if (this$tablePath == null ? other$tablePath != null : !this$tablePath.equals(other$tablePath)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$partitionColumn = this.getPartitionColumn();
        String other$partitionColumn = other.getPartitionColumn();
        if (this$partitionColumn == null ? other$partitionColumn != null : !this$partitionColumn.equals(other$partitionColumn)) {
            return false;
        }
        String this$partitionStart = this.getPartitionStart();
        String other$partitionStart = other.getPartitionStart();
        if (this$partitionStart == null ? other$partitionStart != null : !this$partitionStart.equals(other$partitionStart)) {
            return false;
        }
        String this$partitionEnd = this.getPartitionEnd();
        String other$partitionEnd = other.getPartitionEnd();
        return !(this$partitionEnd == null ? other$partitionEnd != null : !this$partitionEnd.equals(other$partitionEnd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSourceTableConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $partitionNumber = this.getPartitionNumber();
        result = result * 59 + ($partitionNumber == null ? 43 : ((Object)$partitionNumber).hashCode());
        Boolean $useSelectCount = this.getUseSelectCount();
        result = result * 59 + ($useSelectCount == null ? 43 : ((Object)$useSelectCount).hashCode());
        Boolean $skipAnalyze = this.getSkipAnalyze();
        result = result * 59 + ($skipAnalyze == null ? 43 : ((Object)$skipAnalyze).hashCode());
        String $tablePath = this.getTablePath();
        result = result * 59 + ($tablePath == null ? 43 : $tablePath.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $partitionColumn = this.getPartitionColumn();
        result = result * 59 + ($partitionColumn == null ? 43 : $partitionColumn.hashCode());
        String $partitionStart = this.getPartitionStart();
        result = result * 59 + ($partitionStart == null ? 43 : $partitionStart.hashCode());
        String $partitionEnd = this.getPartitionEnd();
        result = result * 59 + ($partitionEnd == null ? 43 : $partitionEnd.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSourceTableConfig(tablePath=" + this.getTablePath() + ", query=" + this.getQuery() + ", partitionColumn=" + this.getPartitionColumn() + ", partitionNumber=" + this.getPartitionNumber() + ", partitionStart=" + this.getPartitionStart() + ", partitionEnd=" + this.getPartitionEnd() + ", useSelectCount=" + this.getUseSelectCount() + ", skipAnalyze=" + this.getSkipAnalyze() + ")";
    }

    public static class JdbcSourceTableConfigBuilder {
        private String tablePath;
        private String query;
        private String partitionColumn;
        private Integer partitionNumber;
        private String partitionStart;
        private String partitionEnd;
        private Boolean useSelectCount;
        private Boolean skipAnalyze;

        JdbcSourceTableConfigBuilder() {
        }

        public JdbcSourceTableConfigBuilder tablePath(String tablePath) {
            this.tablePath = tablePath;
            return this;
        }

        public JdbcSourceTableConfigBuilder query(String query) {
            this.query = query;
            return this;
        }

        public JdbcSourceTableConfigBuilder partitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        public JdbcSourceTableConfigBuilder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public JdbcSourceTableConfigBuilder partitionStart(String partitionStart) {
            this.partitionStart = partitionStart;
            return this;
        }

        public JdbcSourceTableConfigBuilder partitionEnd(String partitionEnd) {
            this.partitionEnd = partitionEnd;
            return this;
        }

        public JdbcSourceTableConfigBuilder useSelectCount(Boolean useSelectCount) {
            this.useSelectCount = useSelectCount;
            return this;
        }

        public JdbcSourceTableConfigBuilder skipAnalyze(Boolean skipAnalyze) {
            this.skipAnalyze = skipAnalyze;
            return this;
        }

        public JdbcSourceTableConfig build() {
            return new JdbcSourceTableConfig(this.tablePath, this.query, this.partitionColumn, this.partitionNumber, this.partitionStart, this.partitionEnd, this.useSelectCount, this.skipAnalyze);
        }

        public String toString() {
            return "JdbcSourceTableConfig.JdbcSourceTableConfigBuilder(tablePath=" + this.tablePath + ", query=" + this.query + ", partitionColumn=" + this.partitionColumn + ", partitionNumber=" + this.partitionNumber + ", partitionStart=" + this.partitionStart + ", partitionEnd=" + this.partitionEnd + ", useSelectCount=" + this.useSelectCount + ", skipAnalyze=" + this.skipAnalyze + ")";
        }
    }
}

