/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.br;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.br.KVDecoder;
import org.tikv.br.SSTIterator;
import org.tikv.shade.com.google.protobuf.ByteString;

public class RawKVDecoderV1
implements KVDecoder {
    private static final Logger logger = LoggerFactory.getLogger(SSTIterator.class);
    private final boolean ttlEnabled;

    public RawKVDecoderV1(boolean ttlEnabled) {
        this.ttlEnabled = ttlEnabled;
    }

    @Override
    public ByteString decodeKey(byte[] key) {
        if (key == null || key.length == 0) {
            logger.warn("skip Key-Value pair because key == null || key.length == 0, key = " + Arrays.toString(key));
            return null;
        }
        if (key[0] != 122) {
            logger.warn("skip Key-Value pair because key[0] != 'z', key = " + Arrays.toString(key));
            return null;
        }
        return ByteString.copyFrom(key, 1, key.length - 1);
    }

    @Override
    public ByteString decodeValue(byte[] value) {
        if (!this.ttlEnabled) {
            return ByteString.copyFrom(value);
        }
        return ByteString.copyFrom(value).substring(0, value.length - 8);
    }
}

