/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.statistics;

import java.util.List;
import org.tikv.common.key.Key;
import org.tikv.common.key.StatisticsKeyRangeBuilder;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.predicates.IndexRange;
import org.tikv.common.statistics.CMSketch;
import org.tikv.common.statistics.Histogram;
import org.tikv.common.util.Pair;

public class IndexStatistics {
    private Histogram histogram;
    private CMSketch cmSketch;
    private TiIndexInfo indexInfo;

    public IndexStatistics(Histogram histogram, CMSketch cmSketch, TiIndexInfo indexInfo) {
        this.histogram = histogram;
        this.cmSketch = cmSketch;
        this.indexInfo = indexInfo;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
    }

    public CMSketch getCmSketch() {
        return this.cmSketch;
    }

    public void setCmSketch(CMSketch cmSketch) {
        this.cmSketch = cmSketch;
    }

    public TiIndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public void setIndexInfo(TiIndexInfo indexInfo) {
        this.indexInfo = indexInfo;
    }

    public double getRowCount(List<IndexRange> indexRanges) {
        double rowCount = 0.0;
        for (IndexRange ir : indexRanges) {
            StatisticsKeyRangeBuilder builder = new StatisticsKeyRangeBuilder(ir);
            Pair<Key, Key> range = builder.compute();
            rowCount += this.histogram.betweenRowCount((Key)range.first, (Key)range.second);
        }
        if (rowCount > this.histogram.totalRowCount()) {
            rowCount = this.histogram.totalRowCount();
        } else if (rowCount < 0.0) {
            rowCount = 0.0;
        }
        return rowCount;
    }
}

