/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.shade.com.google.common.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.common.collect.UnmodifiableIterator;
import org.tikv.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @NullableDecl
    private volatile transient Map.Entry<K, V> cacheEntry;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CanIgnoreReturnValue
    public final V put(@NullableDecl K key, @NullableDecl V value) {
        this.clearCache();
        return this.backingMap.put(key, value);
    }

    @CanIgnoreReturnValue
    public final V remove(@NullableDecl Object key) {
        this.clearCache();
        return this.backingMap.remove(key);
    }

    public final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(@NullableDecl Object key) {
        V value = this.getIfCached(key);
        return value != null ? value : this.getWithoutCaching(key);
    }

    public final V getWithoutCaching(@NullableDecl Object key) {
        return this.backingMap.get(key);
    }

    public final boolean containsKey(@NullableDecl Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.cacheEntry = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@NullableDecl Object key) {
                return MapIteratorCache.this.containsKey(key);
            }
        };
    }

    protected V getIfCached(@NullableDecl Object key) {
        Map.Entry<K, V> entry = this.cacheEntry;
        if (entry != null && entry.getKey() == key) {
            return entry.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.cacheEntry = null;
    }
}

