/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Collect;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.util.PGInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PostgresDefaultValueConverter
implements DefaultValueConverter {
    private static Logger LOGGER = LoggerFactory.getLogger(PostgresDefaultValueConverter.class);
    private static final Pattern LITERAL_DEFAULT_PATTERN = Pattern.compile("'(.*?)'");
    private static final Pattern FUNCTION_DEFAULT_PATTERN = Pattern.compile("^[(]?[A-Za-z0-9_.]+\\((?:.+(?:, ?.+)*)?\\)");
    private static final Set<String> CURRENT_DATE_TIMES = Collect.unmodifiableSet("current_timestamp", "current_time", "current_date", "localtime", "localtimestamp");
    private static final Set<String> TRIM_DATA_TYPES = Collect.unmodifiableSet("bit", "varbit", "bool", "numeric", "float4", "float8", "int2", "int4", "serial", "int8", "bigserial", "smallserial", "uuid", "date", "time", "timestamp", "timestamptz", "interval");
    private final PostgresValueConverter valueConverters;
    private final Map<String, DefaultValueConverter.DefaultValueMapper> defaultValueMappers;

    public PostgresDefaultValueConverter(PostgresValueConverter valueConverters, TimestampUtils timestampUtils) {
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(PostgresDefaultValueConverter.createDefaultValueMappers(timestampUtils));
    }

    @Override
    public Optional<Object> parseDefaultValue(Column column, String defaultValueExpression) {
        if (defaultValueExpression == null) {
            return Optional.empty();
        }
        String dataType = column.typeName();
        DefaultValueConverter.DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        if (TRIM_DATA_TYPES.contains(dataType)) {
            defaultValueExpression = defaultValueExpression.trim();
        }
        try {
            Object rawDefaultValue = mapper.parse(column, defaultValueExpression);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            if (convertedDefaultValue == null) {
                return Optional.empty();
            }
            if (convertedDefaultValue instanceof Struct) {
                LOGGER.warn("Struct can't be used as default value for column '{}', will use null instead.", (Object)column.name());
                return Optional.empty();
            }
            return Optional.of(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'. Expression evaluation is not supported.", (Object)defaultValueExpression, (Object)dataType);
            LOGGER.debug("Parsing failed due to error", (Throwable)e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        if (this.valueConverters != null && defaultValue != null) {
            SchemaBuilder schemaBuilder = this.valueConverters.schemaBuilder(column);
            if (schemaBuilder == null) {
                return defaultValue;
            }
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            Object result = valueConverter.convert(defaultValue);
            if (result instanceof BigDecimal && column.scale().isPresent() && column.scale().get() > ((BigDecimal)result).scale()) {
                result = ((BigDecimal)result).setScale((int)column.scale().get(), RoundingMode.HALF_EVEN);
            }
            return result;
        }
        return defaultValue;
    }

    private static DefaultValueConverter.DefaultValueMapper parseNullDefault(DefaultValueConverter.DefaultValueMapper mapper) {
        return (c, x) -> {
            if (x.startsWith("NULL::")) {
                return null;
            }
            return mapper.parse(c, x);
        };
    }

    private static Map<String, DefaultValueConverter.DefaultValueMapper> createDefaultValueMappers(TimestampUtils timestampUtils) {
        HashMap<String, DefaultValueConverter.DefaultValueMapper> result = new HashMap<String, DefaultValueConverter.DefaultValueMapper>();
        result.put("bit", (c, v) -> {
            String defaultValue = PostgresDefaultValueConverter.extractDefault(v, "00");
            if (defaultValue.length() == 1) {
                return "1".equals(defaultValue);
            }
            return defaultValue;
        });
        result.put("varbit", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, "0"));
        result.put("bool", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Boolean.parseBoolean(PostgresDefaultValueConverter.extractDefault(v, "false"))));
        result.put("bpchar", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("varchar", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("text", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("numeric", PostgresDefaultValueConverter.parseNullDefault((c, v) -> new BigDecimal(PostgresDefaultValueConverter.extractDefault(v, "0.0"))));
        result.put("float4", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Float.valueOf(Float.parseFloat(PostgresDefaultValueConverter.extractDefault(v, "0.0")))));
        result.put("float8", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Double.parseDouble(PostgresDefaultValueConverter.extractDefault(v, "0.0"))));
        result.put("int2", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Short.parseShort(PostgresDefaultValueConverter.extractDefault(v, "0"))));
        result.put("int4", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Integer.parseInt(PostgresDefaultValueConverter.extractDefault(v, "0"))));
        result.put("serial", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Integer.parseInt(PostgresDefaultValueConverter.extractDefault(v, "0"))));
        result.put("int8", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Long.parseLong(PostgresDefaultValueConverter.extractDefault(v, "0"))));
        result.put("bigserial", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Long.parseLong(PostgresDefaultValueConverter.extractDefault(v, "0"))));
        result.put("smallserial", PostgresDefaultValueConverter.parseNullDefault((c, v) -> Short.parseShort(PostgresDefaultValueConverter.extractDefault(v, "0"))));
        result.put("json", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, "{}"));
        result.put("jsonb", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, "{}"));
        result.put("xml", (c, v) -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("uuid", (c, v) -> UUID.fromString(PostgresDefaultValueConverter.extractDefault(v, "00000000-0000-0000-0000-000000000000")));
        result.put("date", (c, v) -> timestampUtils.toLocalDateTime(PostgresDefaultValueConverter.extractDefault(v, "1970-01-01")));
        result.put("time", (c, v) -> timestampUtils.toLocalTime(PostgresDefaultValueConverter.extractDefault(v, "00:00")));
        result.put("timestamp", (c, v) -> timestampUtils.toOffsetDateTime(PostgresDefaultValueConverter.extractDefault(v, "1970-01-01")));
        result.put("timestamptz", (c, v) -> timestampUtils.toOffsetDateTime(PostgresDefaultValueConverter.extractDefault(v, "1970-01-01")).atZoneSameInstant(ZoneOffset.UTC));
        result.put("interval", (c, v) -> new PGInterval(PostgresDefaultValueConverter.extractDefault(v, "epoch")));
        return result;
    }

    private static String extractDefault(String defaultValue) {
        if (!defaultValue.contains("'")) {
            return defaultValue.startsWith("NULL::") ? null : defaultValue;
        }
        Matcher matcher = LITERAL_DEFAULT_PATTERN.matcher(defaultValue);
        matcher.find();
        return matcher.group(1);
    }

    private static String extractDefault(String defaultValue, String generatedValuePlaceholder) {
        Matcher functionMatcher = FUNCTION_DEFAULT_PATTERN.matcher(defaultValue);
        if (functionMatcher.find() || CURRENT_DATE_TIMES.contains(defaultValue.toLowerCase())) {
            return generatedValuePlaceholder;
        }
        return PostgresDefaultValueConverter.extractDefault(defaultValue);
    }

    public boolean supportConversion(String typeName) {
        return this.defaultValueMappers.containsKey(typeName);
    }
}

