/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.split;

import io.debezium.relational.TableId;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;

public class SnapshotSplit
extends SourceSplitBase {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final SeaTunnelRowType splitKeyType;
    private final Object[] splitStart;
    private final Object[] splitEnd;
    private final Offset lowWatermark;
    private final Offset highWatermark;

    public SnapshotSplit(String splitId, TableId tableId, SeaTunnelRowType splitKeyType, Object[] splitStart, Object[] splitEnd) {
        this(splitId, tableId, splitKeyType, splitStart, splitEnd, null, null);
    }

    public SnapshotSplit(String splitId, TableId tableId, SeaTunnelRowType splitKeyType, Object[] splitStart, Object[] splitEnd, Offset lowWatermark, Offset highWatermark) {
        super(splitId);
        this.tableId = tableId;
        this.splitKeyType = splitKeyType;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
    }

    @Override
    public String splitId() {
        return this.splitId;
    }

    public boolean isSnapshotReadFinished() {
        return this.lowWatermark != null && this.highWatermark != null;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public SeaTunnelRowType getSplitKeyType() {
        return this.splitKeyType;
    }

    public Object[] getSplitStart() {
        return this.splitStart;
    }

    public Object[] getSplitEnd() {
        return this.splitEnd;
    }

    public Offset getLowWatermark() {
        return this.lowWatermark;
    }

    public Offset getHighWatermark() {
        return this.highWatermark;
    }
}

