/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public interface JdbcDialectTypeMapper
extends Serializable {
    @Deprecated
    default public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnName = metadata.getColumnLabel(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(nativeType).dataType(nativeType).nullable(isNullable == 1).length(Long.valueOf(precision)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return this.mappingColumn(typeDefine).getDataType();
    }

    default public Column mappingColumn(BasicTypeDefine typeDefine) {
        throw new UnsupportedOperationException();
    }

    default public List<Column> mappingColumn(DatabaseMetaData metadata, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        try (ResultSet rs = metadata.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String nativeType = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                int decimalDigits = rs.getInt("DECIMAL_DIGITS");
                int nullable = rs.getInt("NULLABLE");
                BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(nativeType).dataType(nativeType).length(Long.valueOf(columnSize)).precision(Long.valueOf(columnSize)).scale(Integer.valueOf(decimalDigits)).nullable(nullable == 1).build();
                columns.add(this.mappingColumn(typeDefine));
            }
        }
        return columns;
    }

    default public List<Column> mappingColumn(ResultSetMetaData metadata) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int index = 1; index <= metadata.getColumnCount(); ++index) {
            Column column = this.mappingColumn(metadata, index);
            columns.add(column);
        }
        return columns;
    }

    default public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        int precision;
        SeaTunnelDataType<?> seaTunnelType = this.mapping(metadata, colIndex);
        String columnName = metadata.getColumnLabel(colIndex);
        int jdbcType = metadata.getColumnType(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        int columnLength = precision = metadata.getPrecision(colIndex);
        long longColumnLength = precision;
        long bitLength = 0L;
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                bitLength = precision * 8;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                columnLength = precision * 3;
                longColumnLength = precision * 3;
                break;
            }
        }
        return PhysicalColumn.of((String)columnName, seaTunnelType, (Integer)columnLength, (isNullable != 0 ? 1 : 0) != 0, null, null, (String)nativeType, (boolean)false, (boolean)false, (Long)bitLength, Collections.emptyMap(), (Long)longColumnLength);
    }
}

