/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.StringFormatter;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.DestroyWorkerRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.kafka.trogdor.rest.UptimeResponse;
import org.apache.kafka.trogdor.rest.WorkerState;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentClient {
    private final Logger log;
    private final int maxTries;
    private final String target;

    private AgentClient(Logger log, int maxTries, String target) {
        this.log = log;
        this.maxTries = maxTries;
        this.target = target;
    }

    public String target() {
        return this.target;
    }

    public int maxTries() {
        return this.maxTries;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public AgentStatusResponse status() throws Exception {
        JsonRestServer.HttpResponse<AgentStatusResponse> resp = JsonRestServer.httpRequest(this.url("/agent/status"), "GET", null, new TypeReference<AgentStatusResponse>(){}, this.maxTries);
        return resp.body();
    }

    public UptimeResponse uptime() throws Exception {
        JsonRestServer.HttpResponse<UptimeResponse> resp = JsonRestServer.httpRequest(this.url("/agent/uptime"), "GET", null, new TypeReference<UptimeResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void createWorker(CreateWorkerRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/worker/create"), "POST", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void stopWorker(StopWorkerRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/worker/stop"), "PUT", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void destroyWorker(DestroyWorkerRequest request) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath(this.url("/agent/worker"));
        uriBuilder.queryParam("workerId", request.workerId());
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(uriBuilder.build(new Object[0]).toString(), "DELETE", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void invokeShutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/shutdown"), "PUT", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    private static void addTargetArgument(ArgumentParser parser) {
        parser.addArgument("--target", "-t").action(Arguments.store()).required(true).type(String.class).dest("target").metavar("TARGET").help("A colon-separated host and port pair.  For example, example.com:8888");
    }

    private static void addJsonArgument(ArgumentParser parser) {
        parser.addArgument("--json").action(Arguments.storeTrue()).dest("json").metavar("JSON").help("Show the full response as JSON.");
    }

    private static void addWorkerIdArgument(ArgumentParser parser, String help) {
        parser.addArgument("--workerId").action(Arguments.storeTrue()).type(Long.class).dest("workerId").metavar("WORKER_ID").help(help);
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser rootParser = ArgumentParsers.newArgumentParser("trogdor-agent-client").defaultHelp(true).description("The Trogdor agent client.");
        Subparsers subParsers = rootParser.addSubparsers().dest("command");
        Subparser uptimeParser = subParsers.addParser("uptime").help("Get the agent uptime.");
        AgentClient.addTargetArgument(uptimeParser);
        AgentClient.addJsonArgument(uptimeParser);
        Subparser statusParser = subParsers.addParser("status").help("Get the agent status.");
        AgentClient.addTargetArgument(statusParser);
        AgentClient.addJsonArgument(statusParser);
        Subparser createWorkerParser = subParsers.addParser("createWorker").help("Create a new worker.");
        AgentClient.addTargetArgument(createWorkerParser);
        AgentClient.addWorkerIdArgument(createWorkerParser, "The worker ID to create.");
        createWorkerParser.addArgument("--taskId").action(Arguments.store()).required(true).type(String.class).dest("taskId").metavar("TASK_ID").help("The task ID to create.");
        createWorkerParser.addArgument("--spec", "-s").action(Arguments.store()).required(true).type(String.class).dest("taskSpec").metavar("TASK_SPEC").help("The task spec to create, or a path to a file containing the task spec.");
        Subparser stopWorkerParser = subParsers.addParser("stopWorker").help("Stop a worker.");
        AgentClient.addTargetArgument(stopWorkerParser);
        AgentClient.addWorkerIdArgument(stopWorkerParser, "The worker ID to stop.");
        Subparser destroyWorkerParser = subParsers.addParser("destroyWorker").help("Destroy a worker.");
        AgentClient.addTargetArgument(destroyWorkerParser);
        AgentClient.addWorkerIdArgument(destroyWorkerParser, "The worker ID to destroy.");
        Subparser shutdownParser = subParsers.addParser("shutdown").help("Shut down the agent.");
        AgentClient.addTargetArgument(shutdownParser);
        Namespace res = rootParser.parseArgsOrFail(args);
        String target = res.getString("target");
        AgentClient client = new Builder().maxTries(3).target(target).build();
        ZoneOffset localOffset = OffsetDateTime.now().getOffset();
        switch (res.getString("command")) {
            case "uptime": {
                UptimeResponse uptime = client.uptime();
                if (res.getBoolean("json").booleanValue()) {
                    System.out.println(JsonUtil.toJsonString(uptime));
                    break;
                }
                System.out.printf("Agent is running at %s.%n", target);
                System.out.printf("\tStart time: %s%n", StringFormatter.dateString(uptime.serverStartMs(), localOffset));
                System.out.printf("\tCurrent server time: %s%n", StringFormatter.dateString(uptime.nowMs(), localOffset));
                System.out.printf("\tUptime: %s%n", StringFormatter.durationString(uptime.nowMs() - uptime.serverStartMs()));
                break;
            }
            case "status": {
                AgentStatusResponse status = client.status();
                if (res.getBoolean("json").booleanValue()) {
                    System.out.println(JsonUtil.toJsonString(status));
                    break;
                }
                System.out.printf("Agent is running at %s.%n", target);
                System.out.printf("\tStart time: %s%n", StringFormatter.dateString(status.serverStartMs(), localOffset));
                ArrayList<List<String>> lines = new ArrayList<List<String>>();
                ArrayList<String> header = new ArrayList<String>(Arrays.asList("WORKER_ID", "TASK_ID", "STATE", "TASK_TYPE"));
                lines.add(header);
                for (Map.Entry<Long, WorkerState> entry : status.workers().entrySet()) {
                    ArrayList<String> cols = new ArrayList<String>();
                    cols.add(Long.toString(entry.getKey()));
                    cols.add(entry.getValue().taskId());
                    cols.add(entry.getValue().getClass().getSimpleName());
                    cols.add(entry.getValue().spec().getClass().getCanonicalName());
                    lines.add(cols);
                }
                System.out.print(StringFormatter.prettyPrintGrid(lines));
                break;
            }
            case "createWorker": {
                long workerId = res.getLong("workerId");
                String taskId = res.getString("taskId");
                TaskSpec taskSpec = JsonUtil.objectFromCommandLineArgument(res.getString("taskSpec"), TaskSpec.class);
                CreateWorkerRequest req = new CreateWorkerRequest(workerId, taskId, taskSpec);
                client.createWorker(req);
                System.out.printf("Sent CreateWorkerRequest for worker %d%n.", req.workerId());
                break;
            }
            case "stopWorker": {
                long workerId = res.getLong("workerId");
                client.stopWorker(new StopWorkerRequest(workerId));
                System.out.printf("Sent StopWorkerRequest for worker %d%n.", workerId);
                break;
            }
            case "destroyWorker": {
                long workerId = res.getLong("workerId");
                client.destroyWorker(new DestroyWorkerRequest(workerId));
                System.out.printf("Sent DestroyWorkerRequest for worker %d%n.", workerId);
                break;
            }
            case "shutdown": {
                client.invokeShutdown();
                System.out.println("Sent ShutdownRequest.");
                break;
            }
            default: {
                System.out.println("You must choose an action. Type --help for help.");
                Exit.exit(1);
            }
        }
    }

    public static class Builder {
        private Logger log = LoggerFactory.getLogger(AgentClient.class);
        private int maxTries = 1;
        private String target = null;

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder target(String host, int port) {
            this.target = String.format("%s:%d", host, port);
            return this;
        }

        public AgentClient build() {
            if (this.target == null) {
                throw new RuntimeException("You must specify a target.");
            }
            return new AgentClient(this.log, this.maxTries, this.target);
        }
    }
}

