/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium.row;

import com.google.common.base.Preconditions;
import io.debezium.data.Envelope;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationConverterFactory;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.seatunnel.connectors.cdc.debezium.MetadataConverter;
import org.apache.seatunnel.connectors.cdc.debezium.row.SeaTunnelRowDebeziumDeserializationConverters;

public final class SeaTunnelRowDebeziumDeserializeSchema
implements DebeziumDeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private final SeaTunnelDataType<SeaTunnelRow> resultTypeInfo;
    private final SeaTunnelRowDebeziumDeserializationConverters converters;
    private final ValueValidator validator;

    public static Builder builder() {
        return new Builder();
    }

    SeaTunnelRowDebeziumDeserializeSchema(SeaTunnelRowType physicalDataType, MetadataConverter[] metadataConverters, SeaTunnelRowType resultType, ValueValidator validator, ZoneId serverTimeZone, DebeziumDeserializationConverterFactory userDefinedConverterFactory) {
        this.converters = new SeaTunnelRowDebeziumDeserializationConverters(physicalDataType, metadataConverters, serverTimeZone, userDefinedConverterFactory);
        this.resultTypeInfo = (SeaTunnelDataType)Preconditions.checkNotNull(resultType);
        this.validator = Preconditions.checkNotNull(validator);
    }

    @Override
    public void deserialize(SourceRecord record, Collector<SeaTunnelRow> collector) throws Exception {
        Envelope.Operation operation = Envelope.operationFor(record);
        Struct messageStruct = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        Struct sourceStruct = messageStruct.getStruct("source");
        String tableName = sourceStruct.getString("table");
        if (operation == Envelope.Operation.CREATE || operation == Envelope.Operation.READ) {
            SeaTunnelRow insert = this.extractAfterRow(this.converters, record, messageStruct, valueSchema);
            insert.setRowKind(RowKind.INSERT);
            this.validator.validate(insert, RowKind.INSERT);
            collector.collect((Object)insert);
        } else if (operation == Envelope.Operation.DELETE) {
            SeaTunnelRow delete = this.extractBeforeRow(this.converters, record, messageStruct, valueSchema);
            this.validator.validate(delete, RowKind.DELETE);
            delete.setRowKind(RowKind.DELETE);
            collector.collect((Object)delete);
        } else {
            SeaTunnelRow before = this.extractBeforeRow(this.converters, record, messageStruct, valueSchema);
            this.validator.validate(before, RowKind.UPDATE_BEFORE);
            before.setRowKind(RowKind.UPDATE_BEFORE);
            collector.collect((Object)before);
            SeaTunnelRow after = this.extractAfterRow(this.converters, record, messageStruct, valueSchema);
            this.validator.validate(after, RowKind.UPDATE_AFTER);
            after.setRowKind(RowKind.UPDATE_AFTER);
            collector.collect((Object)after);
        }
    }

    private SeaTunnelRow extractAfterRow(SeaTunnelRowDebeziumDeserializationConverters runtimeConverter, SourceRecord record, Struct value, Schema valueSchema) throws Exception {
        Schema afterSchema = valueSchema.field("after").schema();
        Struct after = value.getStruct("after");
        return runtimeConverter.convert(record, after, afterSchema);
    }

    private SeaTunnelRow extractBeforeRow(SeaTunnelRowDebeziumDeserializationConverters runtimeConverter, SourceRecord record, Struct value, Schema valueSchema) throws Exception {
        Schema beforeSchema = valueSchema.field("before").schema();
        Struct before = value.getStruct("before");
        return runtimeConverter.convert(record, before, beforeSchema);
    }

    @Override
    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.resultTypeInfo;
    }

    public static class Builder {
        private SeaTunnelRowType physicalRowType;
        private SeaTunnelRowType resultTypeInfo;
        private MetadataConverter[] metadataConverters = new MetadataConverter[0];
        private ValueValidator validator = (rowData, rowKind) -> {};
        private ZoneId serverTimeZone = ZoneId.of("UTC");
        private DebeziumDeserializationConverterFactory userDefinedConverterFactory = DebeziumDeserializationConverterFactory.DEFAULT;

        public Builder setPhysicalRowType(SeaTunnelRowType physicalRowType) {
            this.physicalRowType = physicalRowType;
            return this;
        }

        public Builder setMetadataConverters(MetadataConverter[] metadataConverters) {
            this.metadataConverters = metadataConverters;
            return this;
        }

        public Builder setResultTypeInfo(SeaTunnelRowType resultTypeInfo) {
            this.resultTypeInfo = resultTypeInfo;
            return this;
        }

        public Builder setValueValidator(ValueValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder setServerTimeZone(ZoneId serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Builder setUserDefinedConverterFactory(DebeziumDeserializationConverterFactory userDefinedConverterFactory) {
            this.userDefinedConverterFactory = userDefinedConverterFactory;
            return this;
        }

        public SeaTunnelRowDebeziumDeserializeSchema build() {
            return new SeaTunnelRowDebeziumDeserializeSchema(this.physicalRowType, this.metadataConverters, this.resultTypeInfo, this.validator, this.serverTimeZone, this.userDefinedConverterFactory);
        }
    }

    public static interface ValueValidator
    extends Serializable {
        public void validate(SeaTunnelRow var1, RowKind var2) throws Exception;
    }
}

