/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.offset;

import io.debezium.connector.sqlserver.Lsn;
import java.util.HashMap;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;

public class LsnOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final LsnOffset INITIAL_OFFSET = new LsnOffset(Lsn.valueOf(new byte[]{-128}));
    public static final LsnOffset NO_STOPPING_OFFSET = new LsnOffset(Lsn.valueOf(new byte[]{127}));

    public LsnOffset(Lsn changeLsn) {
        this(changeLsn, null, null);
    }

    public LsnOffset(Lsn changeLsn, Lsn commitLsn, Long eventSerialNo) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        if (changeLsn != null && changeLsn.isAvailable()) {
            offsetMap.put("change_lsn", changeLsn.toString());
        }
        if (commitLsn != null && commitLsn.isAvailable()) {
            offsetMap.put("commit_lsn", commitLsn.toString());
        }
        if (eventSerialNo != null) {
            offsetMap.put("event_serial_no", String.valueOf(eventSerialNo));
        }
        this.offset = offsetMap;
    }

    public Lsn getChangeLsn() {
        return Lsn.valueOf((String)this.offset.get("change_lsn"));
    }

    @Override
    public int compareTo(Offset o) {
        LsnOffset that = (LsnOffset)o;
        if (NO_STOPPING_OFFSET.equals(that) && NO_STOPPING_OFFSET.equals(this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals(this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals(that)) {
            return -1;
        }
        Lsn thisChangeLsn = this.getChangeLsn();
        Lsn thatChangeLsn = that.getChangeLsn();
        if (thatChangeLsn.isAvailable()) {
            if (thisChangeLsn.isAvailable()) {
                return thisChangeLsn.compareTo(thatChangeLsn);
            }
            return -1;
        }
        if (thisChangeLsn.isAvailable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LsnOffset)) {
            return false;
        }
        LsnOffset that = (LsnOffset)o;
        return this.offset.equals(that.offset);
    }
}

