/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.utils;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.util.List;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;

public class SqlServerTypeUtils {
    public static SeaTunnelDataType<?> convertFromColumn(Column column) {
        switch (column.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: {
                return BasicType.STRING_TYPE;
            }
            case 2004: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case 4: {
                return BasicType.INT_TYPE;
            }
            case -6: 
            case 5: {
                return BasicType.SHORT_TYPE;
            }
            case -5: {
                return BasicType.LONG_TYPE;
            }
            case 6: 
            case 7: {
                return BasicType.FLOAT_TYPE;
            }
            case 8: {
                return BasicType.DOUBLE_TYPE;
            }
            case 2: 
            case 3: {
                return new DecimalType(column.length(), column.scale().orElse(0).intValue());
            }
            case 93: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case 91: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case 92: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case -7: 
            case 16: {
                return BasicType.BOOLEAN_TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support SqlSever type '%s' yet, jdbcType:'%s'.", column.typeName(), column.jdbcType()));
    }

    public static SeaTunnelRowType convertFromTable(Table table) {
        List<Column> columns = table.columns();
        String[] fieldNames = (String[])columns.stream().map(Column::name).toArray(String[]::new);
        SeaTunnelDataType[] fieldTypes = (SeaTunnelDataType[])columns.stream().map(SqlServerTypeUtils::convertFromColumn).toArray(SeaTunnelDataType[]::new);
        return new SeaTunnelRowType(fieldNames, fieldTypes);
    }
}

