/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.config;

import com.google.common.base.Preconditions;
import io.debezium.connector.sqlserver.SqlServerConnector;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfigFactory;
import org.apache.seatunnel.connectors.cdc.debezium.EmbeddedDatabaseHistory;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.config.SqlServerSourceConfig;

public class SqlServerSourceConfigFactory
extends JdbcSourceConfigFactory {
    private static final String DATABASE_SERVER_NAME = "sqlserver_transaction_log_source";
    private static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    @Override
    public SqlServerSourceConfig create(int subtask) {
        Properties props = new Properties();
        props.setProperty("connector.class", SqlServerConnector.class.getCanonicalName());
        props.setProperty("database.server.name", DATABASE_SERVER_NAME);
        props.setProperty("database.hostname", Preconditions.checkNotNull(this.hostname));
        props.setProperty("database.user", Preconditions.checkNotNull(this.username));
        props.setProperty("database.password", Preconditions.checkNotNull(this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.dbname", (String)Preconditions.checkNotNull(this.databaseList.get(0)));
        props.setProperty("database.history", EmbeddedDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID() + "_" + subtask);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("include.schema.changes", String.valueOf(false));
        if (this.databaseList != null) {
            props.setProperty("database.include.list", String.join((CharSequence)",", this.databaseList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", this.tableList.stream().map(tableStr -> tableStr.substring(tableStr.indexOf(".") + 1)).collect(Collectors.joining(",")));
        }
        if (this.dbzProperties != null) {
            this.dbzProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)props::put));
        }
        return new SqlServerSourceConfig(this.startupConfig, this.stopConfig, this.databaseList, this.tableList, this.splitSize, this.distributionFactorUpper, this.distributionFactorLower, props, DRIVER_CLASS_NAME, this.hostname, this.port, this.username, this.password, this.originUrl, this.fetchSize, this.serverTimeZone, this.connectTimeoutMillis, this.connectMaxRetries, this.connectionPoolSize);
    }
}

