/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.offset;

import io.debezium.connector.sqlserver.Lsn;
import java.util.HashMap;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;

public class LsnOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final LsnOffset INITIAL_OFFSET = LsnOffset.valueOf(Lsn.valueOf(new byte[]{0}).toString());
    public static final LsnOffset NO_STOPPING_OFFSET = LsnOffset.valueOf(Lsn.valueOf(new byte[]{127}).toString());

    public static LsnOffset valueOf(String commitLsn) {
        return new LsnOffset(Lsn.valueOf(commitLsn), null, null);
    }

    private LsnOffset(Lsn commitLsn, Lsn changeLsn, Long eventSerialNo) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        if (commitLsn != null && commitLsn.isAvailable()) {
            offsetMap.put("commit_lsn", commitLsn.toString());
        }
        if (changeLsn != null && changeLsn.isAvailable()) {
            offsetMap.put("change_lsn", changeLsn.toString());
        }
        if (eventSerialNo != null) {
            offsetMap.put("event_serial_no", String.valueOf(eventSerialNo));
        }
        this.offset = offsetMap;
    }

    public Lsn getChangeLsn() {
        return Lsn.valueOf((String)this.offset.get("change_lsn"));
    }

    public Lsn getCommitLsn() {
        return Lsn.valueOf((String)this.offset.get("commit_lsn"));
    }

    public Long getEventSerialNo() {
        return Long.valueOf((String)this.offset.get("event_serial_no"));
    }

    @Override
    public int compareTo(Offset o) {
        LsnOffset that = (LsnOffset)o;
        int comparison = this.getCommitLsn().compareTo(that.getCommitLsn());
        return comparison == 0 ? this.getChangeLsn().compareTo(that.getChangeLsn()) : comparison;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LsnOffset other = (LsnOffset)obj;
        return this.offset.equals(other.offset);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getCommitLsn() == null ? 0 : this.getCommitLsn().hashCode());
        result = 31 * result + (this.getChangeLsn() == null ? 0 : this.getChangeLsn().hashCode());
        result = 31 * result + (this.getEventSerialNo() == null ? 0 : this.getEventSerialNo().hashCode());
        return result;
    }
}

