/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.compatible.debezium.json;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.compatible.debezium.json.DebeziumJsonConverter;

public class CompatibleDebeziumJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    public static final String IDENTIFIER = "compatible_debezium_json";
    public static final String FIELD_TOPIC = "topic";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_VALUE = "value";
    public static final SeaTunnelRowType DEBEZIUM_DATA_ROW_TYPE = new SeaTunnelRowType(new String[]{"topic", "key", "value"}, new SeaTunnelDataType[]{BasicType.STRING_TYPE, BasicType.STRING_TYPE, BasicType.STRING_TYPE});
    private final DebeziumJsonConverter debeziumJsonConverter;

    public CompatibleDebeziumJsonDeserializationSchema(boolean keySchemaEnable, boolean valueSchemaEnable) {
        this.debeziumJsonConverter = new DebeziumJsonConverter(keySchemaEnable, valueSchemaEnable);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedEncodingException();
    }

    public SeaTunnelRow deserialize(SourceRecord record) throws InvocationTargetException, IllegalAccessException {
        String key = this.debeziumJsonConverter.serializeKey(record);
        String value = this.debeziumJsonConverter.serializeValue(record);
        Object[] fields = new Object[]{record.topic(), key, value};
        SeaTunnelRow row = new SeaTunnelRow(fields);
        return row;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return DEBEZIUM_DATA_ROW_TYPE;
    }
}

