/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.br;

import java.util.Iterator;
import org.rocksdb.SstFileReaderIterator;
import org.tikv.br.KVDecoder;
import org.tikv.common.util.Pair;
import org.tikv.shade.com.google.protobuf.ByteString;

public class SSTIterator
implements Iterator<Pair<ByteString, ByteString>> {
    private final SstFileReaderIterator iterator;
    private final KVDecoder kvDecoder;
    private Pair<ByteString, ByteString> nextPair;

    public SSTIterator(SstFileReaderIterator iterator, KVDecoder kvDecoder) {
        this.iterator = iterator;
        this.kvDecoder = kvDecoder;
        this.iterator.seekToFirst();
        this.nextPair = this.processNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextPair != null;
    }

    @Override
    public Pair<ByteString, ByteString> next() {
        Pair<ByteString, ByteString> result = this.nextPair;
        this.nextPair = this.processNext();
        return result;
    }

    private Pair<ByteString, ByteString> processNext() {
        if (this.iterator.isValid()) {
            ByteString key = this.kvDecoder.decodeKey(this.iterator.key());
            ByteString value = this.kvDecoder.decodeValue(this.iterator.value());
            this.iterator.next();
            if (key != null) {
                return Pair.create(key, value);
            }
            return this.processNext();
        }
        return null;
    }
}

